@extends('admin.layout.master')
@section('content')
@include('admin/send_mail/script_js')
<style>
    option {
        font-size: 12px !important;
    }
</style>
<div class="container-fluid">
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.send_multi_email')}}</span>  
            <div class='fs-5 float-end'>
                <a href=""><i class="fa fa-history text-dark" aria-hidden="true"></i></a>
            </div>
        </div>
        <div class="col-12 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row">
                    <div class="col-4">
                        <div>
                            <select id="users" class="form-select rounded-pill">
                                <option value="" selected> {{ trans('admin.all_users') }} </option>
                                {!! getUserTypeList() !!}
                            </select>
                        </div>
                    </div>
                    <div class="col-4">
                        <div>
                            <select id="languages" class="form-select rounded-pill">
                                <option value="" selected> All Languages</option>
                                <option value="en"> English </option>
                                <option value="ar"> Arabic </option>
                            </select>
                        </div>
                    </div>
                    <div class="col-4">
                        <div>
                            <button type="button" class="btn btn-secondary rounded-pill clear">Clear</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<section>
    <div class="container-fluid">
        <div class="row p-2">
            <div class="col-md-12">
                <form id="send_mail" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                        <div class="col-md-5">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label label">Subject</label>
                                <input type="text" class="form-control rounded-pill bg-light_c @error('subject') is-invalid @enderror" name="subject" id="subject" value="{{ old('subject') }}">
                            </div>
                            <div class="mb-3">
                                <label for="hosts" class="form-label label">Hosts</label>
                                <select  id="hosts" class="form-select rounded-pill bg-light cat" name="hosts">
                                    <option value="">Select</option>
                                    @foreach(email_host_list() as $host)
                                    <option value="{{$host->id}}" @if($host->is_default == 1) selected @endif>{{$host->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="template" class="form-label label">Templates</label>
                                <select  id="template" class="form-select rounded-pill bg-light cat" name="template">
                                    <option value="">Select</option>
                                    @foreach(templates_list() as $temp)
                                    <option value="{{$temp->id}}">{{$temp->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="mb-3">
                                <div class="container bg-light p-2">
                                    <i class="bi bi-question-circle-fill" style="font-size: 20px; padding-top:10px;"></i> <span class='fw-bold text-dark mt-2'>Parameters</span>
                                    <p id="params"></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7">  
                            <div class="mb-3 position-relative">
                                <label for="exampleFormControlTextarea1" class="form-label label">Message</label>
                                <textarea data-emojiable="true" data-emoji-input="unicode" class="form-control bg-light_c textarea-round cat @error('message') is-invalid @enderror" name="message" id="message" rows="8" placeholder="{{trans('admin.write_somethings')}}"></textarea>
                                
                                <div class="btn-group position-absolute bottom-0 p-2" role="group" aria-label="Basic example">
                                    <lable for="html_btn" type="button" class="btn btn-info col-upload border-0 click bg-light">
                                        <i class="bi bi-paperclip px-1 fs-6"></i>Attach
                                    </lable>
                                    <input id="active_btn" name="attach[]" type='file' multiple hidden/>
                                </div>
                            </div>
                            <div class="mb-1">
                              <label id="g_label" class="text-info font-weight-bold"></label>
                              <div class="row" id="preview_img">
                                <!-- will preview here -->
                              </div>
                            </div>
                            <div class="container text-center">
                                <p class='fs-6 mt-2 fw-bold'>Total Receivers : <span id="counter"></span></p>
                                <div class='d-grid'>
                                    <button type="submit" class="btn btn-primary col-bt rounded-pill my-4">{{trans('admin.send')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <hr>
            <!-- END 12 COL  -->
            <div class="col-md-12">
                <table class="table table-striped|sm|bordered|inverse table-responsive data-table">
                    <thead>
                        <tr>
                            <th class='text-start text-secondary'>
                                <label class="container1 p-2 ms-1">
                                    <input type="checkbox" id="allchk" class="allchk check-all" label="check all"/>
                                    <span class="checkmark"></span>
                                    <!-- <label class="form-check-label small" for="flexCheckDefault">
                                        Receiver
                                    </label> -->
                                </label>
                            </th>
                            <th class='text-secondary'>Name</th>
                            <th class='text-secondary'>Email</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>
            <!-- END 12 COL  -->            
        </div>
    </div>
</section>
<style>
    #html_btn {
        display: none;
    }
    
    #active_btn {
        display: none;
    }
</style>
<script type="text/javascript">
    CKEDITOR.replace('message');
    var table ="";
    $(function () {
           table = $('.data-table').DataTable({
              processing: true,
              serverSide: true,
              //ajax: "{{ route('send_email') }}",
              ajax: {
                url: "{{ route('send_email') }}",
                data: function(d) {
                    d.user_filter = $('#users').val();
                    d.locale_filter = $('#languages').val();
                    // console.log(d);
                }
              },
              columns: [
                {data: 'id', name: 'id', orderable: false},
                {data: 'name', name: 'name'},
                {data: 'email', name: 'email'},
            ],
      	"lengthMenu": [[10, 25, 50, 100, -1], [100, 200, 500, 700, "All"]]
      });
    });

    /*$("#search_new").on("keyup search input paste cut", function() {
        table.search(this.value).draw();
    });*/
    $('body').on('change', '#users, #languages', function(e) {
        table.draw(true);
    });
    $('body').on('click', '.clear', function(e) {
        $('#users').val("");
        $('#languages').val("");
        table.draw(true);
    });

    $('.click').click(function() {
        $('#active_btn').click();
    });

    $('.new_Btn').click(function() {
        $('#html_btn').click();
    });

    $(document).ready(function(){
        $('#active_btn').on('change', function(){ //on file input change
          if (window.File && window.FileReader && window.FileList && window.Blob) //check File API supported browser
          {
            var data = $(this)[0].files; //this file data
            //$("#g_label").html('{{trans("home.product_image_txt")}}');
            $.each(data, function(index, file){ //loop though each file
              //if(/(\.|\/)(gif|jpe?g|png|pdf|docx)$/i.test(file.type)){ //check supported file type
                var fRead = new FileReader(); //new filereader
                fRead.onload = (function(file){ //trigger function on successful read
                return function(e) {
                  var img = $('<div class="col-2 text-center" id="RemoveIMG'+index+'">\
                      <div style="position: relative;">\
                        <label for="prewImg'+index+'">\
                          <img src="'+e.target.result+'" class="w-100 img rounded" width="100%" style="height: 60px;"/>\
                      </div>\
                      <div onclick="RemoveIMG('+index+');" class="p-2" style="position: absolute; top: -10px; background-color: red; color: white; border-radius: 50px; opacity: 0.8;">\
                        <i class="fa fa-close"></i>\
                      </div>\
                    </div>'); //create image element 
                  $('#preview_img').append(img); //append image to output element
                };
                })(file);
                fRead.readAsDataURL(file); //URL representing the file's data.
              /*} else{
                console_log('file type error');
              }*/
            }); 
          }else{
            console_log('browser support error');
          }
        });
      });
</script>
@endsection