@extends('admin.layout.master')
@section('content')
<!-- THE ROW END HERE -->
<div class='bg-white p-2 rounded m-2'>
    <div class="rowjustify-content-between p-2 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center p-2">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold ' href="{{url('/email_hosts')}}">{{trans('admin.email_hosts')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.add_host')}}</span>
        </div>
    </div>
    <div class='p-3'>
        <form action="{{route('add_email_hosts')}}" method="post">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <div class="row">
                <div class="col-12">
                    @if(session()->has('success'))
                        <div class="bg-success p-2 mt-4 rounded text-white">
                            <span class="input-error">{{ session()->get('success') }}</span>
                        </div>
                    @elseif(session()->has('error'))
                        <div class="bg-danger p-2 mt-4 rounded text-white">
                            <span class="input-error">{{ session()->get('error') }}</span>
                        </div>
                    @endif
                    <!-- @if ($errors->any())
                        <div class="bg-danger p-2 mt-4 rounded text-white">
                            @foreach ($errors->all() as $message)
                                <span class="input-error">{{ $message }}</span><br>
                            @endforeach
                        </div>
                    @endif -->
                </div>
                <div class="col-md-4">
                    <div class="mb-3 font-text">
                        <label for="host_name" class="form-label">{{ trans('admin.host_name') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('host_name') is-invalid @enderror" id="host_name" name="host_name" placeholder="{{ trans('admin.name') }}" aria-describedby="emailHelp">
                        @error('host_name') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3 font-text">
                        <label for="host_address" class="form-label">{{ trans('admin.host_address') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('host_address') is-invalid @enderror" id="host_address" name="host_address" placeholder="{{ trans('admin.host_address') }}" aria-describedby="emailHelp">
                        @error('host_address') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3 font-text">
                        <label for="username" class="form-label">{{ trans('admin.username') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('username') is-invalid @enderror" id="username" name="username" placeholder="{{ trans('admin.name') }}" aria-describedby="emailHelp">
                        @error('username') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3 font-text">
                        <label for="password" class="form-label">{{ trans('admin.password') }}</label>
                        <input type="password" class="form-control rounded-pill bg-light_c border-0 @error('password') is-invalid @enderror" id="password" name="password" placeholder="{{ trans('admin.password') }}" aria-describedby="emailHelp">
                        @error('password') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3 font-text">
                        <label for="port" class="form-label">{{ trans('admin.port') }}</label>
                        <input type="number" class="form-control rounded-pill bg-light_c border-0 @error('port') is-invalid @enderror" id="port" name="port" placeholder="{{ trans('admin.type_here') }}" aria-describedby="emailHelp">
                        @error('port') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3 font-text">
                        <label for="encryption" class="form-label">{{ trans('admin.encryption') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('encryption') is-invalid @enderror" id="encryption" name="encryption" placeholder="{{ trans('admin.enter_here') }}" aria-describedby="emailHelp">
                        @error('encryption') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3 font-text">
                        <label for="from_name" class="form-label">{{ trans('admin.from_name') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('from_name') is-invalid @enderror" id="from_name" name="from_name" placeholder="{{ trans('admin.name') }}" aria-describedby="emailHelp">
                        @error('from_name') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3 font-text">
                        <label for="cc_email" class="form-label">{{ trans('admin.cc_email') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('cc_email') is-invalid @enderror" id="cc_email" name="cc_email" placeholder="{{ trans('admin.type_here') }}" aria-describedby="emailHelp">
                        @error('cc_email') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3 font-text">
                        <label for="bcc_email" class="form-label">{{ trans('admin.bcc_email') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('bcc_email') is-invalid @enderror" id="bcc_email" name="bcc_email" placeholder="{{ trans('admin.type_here') }}" aria-describedby="emailHelp">
                        @error('bcc_email') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <!-- switch start  -->
                    <div class="d-flex justify-content-start py-3 ">
                        <label for="default" class="ms-2 mb-1">{{ trans('admin.default_status') }}</label>
                        <label class="switch ms-5">
                            <input type="checkbox" name="default" id="default" value="1">
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">{{ trans('admin.on') }}</span>
                                <span class="off">{{ trans('admin.off') }}</span>
                            </div>
                        </label>
                    </div>
                    <!-- switch end  -->
                </div>
                <div class="col-md-4">
                    <div class="mb-3 font-text">
                        <label for="from_email" class="form-label">{{ trans('admin.from_email') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('from_email') is-invalid @enderror" id="from_email" name="from_email" placeholder="{{ trans('admin.enter_here') }}" aria-describedby="emailHelp">
                        @error('from_email') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div> <br>
                    <!-- switch start  -->
                    <div class="d-flex justify-content-between py-3 ">
                        <label for="cc_status" class="ms-2 mb-1">{{ trans('admin.cc_status') }}</label>
                        <label class="switch">
                            <input type="checkbox" name="cc_status" id="cc_status" value="1">
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">{{ trans('admin.on') }}</span>
                                <span class="off">{{ trans('admin.off') }}</span>
                            </div>
                        </label>
                    </div>
                    <!-- switch end  -->
                    <br>
                    <!-- switch start  -->
                    <div class="d-flex justify-content-between py-3 ">
                        <label for="bcc_status" class="ms-2 mb-1">{{ trans('admin.bcc_status') }}</label>
                        <label class="switch">
                            <input type="checkbox" name="bcc_status" id="bcc_status" value="1">
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="off">{{ trans('admin.off') }}</span>
                                <span class="on">{{ trans('admin.on') }}</span>
                            </div>
                        </label>
                    </div>
                    <!-- switch end  -->
                    <br>
                    <!-- switch start  -->
                    <div class="d-flex justify-content-between py-3 ">
                        <label for="status" class="ms-2 mb-1">{{ trans('admin.status') }}</label>
                        <label class="switch">
                            <input type="checkbox" name="status" id="status" value="1">
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">{{ trans('admin.on') }}</span>
                                <span class="off">{{ trans('admin.off') }}</span>
                            </div>
                        </label>
                    </div>
                    <!-- switch end  -->
                </div>
            </div>

    </div>
    <button type='sumbit' class='btn  btn-color rounded-pill text-light px-5 mt-3 '>{{ trans('admin.add') }}</button>
    </form>
</div>
</div>
@endsection
