<script type="text/javascript" >
$(document).ready(function () {
   $("#save_user").on('submit', (function (e) {
      e.preventDefault();
      var role_en = $("#role_name_en").val();
      var role_ar = $("#role_name_ar").val();
      if (role_en == "" || role_ar=="") {
        swal("{{trans('admin.empty_fields_are_not_allowed')}}","warn");
      }else{
        var view = 0; var add = 0; var edit = 0; var delet = 0;
        if($("#view").is(':checked')) { view = 1; }
        if($("#add").is(':checked')) { add = 1; }
        if($("#edit").is(':checked')) { edit = 1; }
        if($("#delete").is(':checked')) { delet = 1; }
        $.ajax({
            url:'{{url("/user_roles/save")}}',
            data:{
                lbl_en:role_en, lbl_ar:role_ar, view_status:view,
                add_status:add, edit_status:edit, delete_status:delet
            },
            type:'POST',
            headers: {
              'X-CSRF-TOKEN': '{{ csrf_token()}}'
            },
            dataType:'json',
            success: function(res){
              //window.location.reload();
              swal(res.text,res.cls);
            },
            error: function(err){
              alert(err.statusText);
            }
        });
      }
   }));

   //Updating User record
   $("#update_user").on('submit', (function (e) {
      e.preventDefault();
      var id = $("#id").val();
      var per_id = $("#per_id").val();
      var role_en = $("#role_name_ene").val();
      var role_ar = $("#role_name_are").val();
      if (role_en == "" || role_ar=="") {
        swal("{{trans('admin.empty_fields_are_not_allowed')}}","warn");
      }else{
        var view = 0; var add = 0; var edit = 0; var delet = 0;
        if($("#viewe").is(':checked')) { view = 1; }
        if($("#adde").is(':checked')) { add = 1; }
        if($("#edite").is(':checked')) { edit = 1; }
        if($("#deletee").is(':checked')) { delet = 1; }
        $.ajax({
           url: '{{url("/user_roles/update")}}',
           data:{
              lbl_en:role_en, lbl_ar:role_ar, view_status:view,
              add_status:add, edit_status:edit, delete_status:delet, id:id, per_id:per_id
           },
           type: "POST",
           dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token()}}'
            },
           cache: false,
           success: function (data) {
              swal(data.text,data.cls);
              $("#spiner-update_user").removeClass('fa fa-refresh fa-spin');
           },
           error: function (xhr) {
              $("#status_update").html("Error: - " + xhr.status + " " + xhr.statusText);
              $("#spiner-update_user").removeClass('fa fa-refresh fa-spin');
           }
       });
      }
    }));
  });

  function delete_user(id){
    try{
    if(confirm('{{trans("admin.Are_you_sure_to_delete")}}')){
      $.ajax({
        url: '{{url("/user_roles/destroy")}}',
        data:{
          _token: '{!! csrf_token() !!}',
          id:id
        },
        type:"POST",
        dataType: 'json',
        cache:false,
        success: function(res){
          swal(res.text,res.cls);
          $("#"+id).hide(2000);
        },
        error: function(xhr){
          alert('Error: - </b>'+xhr.status+' '+xhr.statusText);
          }
        });
      }
    }catch(e){
      alert(e.message);
    }
  }

  function add_user(){
  $("#status_msg").html('');
  try{
   $("#adduser").modal("show");
   $.ajax({
     url: '{{url("/user_roles/addModel")}}',
     data:{
       _token: '{!! csrf_token() !!}',
     },
     type: 'POST',
     cache:false,
     success: function(frm){
       $("#box").html(frm);
       },
     error: function(xhr){
       $("#box").html(xhr.status+' '+xhr.statusText);
       }
     });
   }catch(e){
     alert(e.message);
   }
  };

 function edit_user(id){
   $("#status_update").html('');
  try{
    $("#edituser").modal("show");
    $.ajax({
      url: '{{url("/user_roles/editModel")}}',
      data:{
        _token: '{!! csrf_token() !!}',
        id:id
      },
      type: 'POST',
      cache:false,
      success: function(frm){
        $("#box_edit").html(frm);
        },
      error: function(xhr){
        $("#box_edit").html(xhr.status+' '+xhr.statusText);
        }
      });
    }catch(e){
      alert(e.message);
    }
  };

  function enbchk(val){
    var checkBox = document.getElementById("all");
    if (checkBox.checked == true){
      $("#view").prop('checked', true);
      $("#add").prop('checked', true);
      $("#edit").prop('checked', true);
      $("#delete").prop('checked', true);
    }else{
      $("#view").prop('checked', false);
      $("#add").prop('checked', false);
      $("#edit").prop('checked', false);
      $("#delete").prop('checked', false);
    }
  }
</script>
