@extends('admin.layout.master')
@section('content')
{{-- @include('admin/menu/menu_js') --}}
<div class="nav-scroller bg-light shado-sm mx-3 mt-2 border">
  <nav class="nav nav-underline align-items-center">
    <li class="nav-item">
        <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> 
		<span class="bi bi-caret-right fw-bold">   <a class='text-decoration-none fw-bold ' href="{{url('/user_roles')}}">{{trans('admin.roles')}}  </a> </span>
	<span class="bi bi-caret-right fw-bold">  @if (Session::get('locale') == 'ar'){{$role->lbl_ar}} @else {{$role->name}} @endif</span>
    </li>
    <li class="nav-item ms-auto">
       {{trans('admin.assign_permissions')}}
      </a>
    </li>
  </nav>
</div>
<main class="container-fluid px-0 scroll-y">
    <!-- body content  -->
    <div class="card card-invoice rounded border-0">
      <div class="card-body pt-0">
          @if(session()->has('message'))
            <div class="alert alert-success">
                {{ session()->get('message') }}
            </div>
        @endif
        <div class="row g-2 p-0 align-items-end bg-light px-2 pb-2 border mt-1 mx-0 no-print" id="from_to_date_area">
         {{-- <ul class="list-group">
              @foreach ($ParentMenu as $item)
              <li class="list-group-item">
                <label>
                    <input class="form-check-input me-1" type="checkbox" value="">
                    {{$item->menu_name}}
                </label>

                <ul class="list-group">
                    <li class="list-group-item">
                        @foreach ($ChildMenu as $val)
                                @if ($val->parent_id == $item->id)
                                    <label>
                                         <input class="form-check-input me-1" type="checkbox" value="">
                                            {{$val->menu_name}}
                                    </label>
                                @endif
                        @endforeach
                </li>
                </ul>
              @endforeach

            </ul> --}}

        <form action="{{route('assign-permission')}}" class="form-horizontal group-border hover-stripped" method="post" accept-charset="utf-8">
            <table class="display table table-bordered table-striped" id="dynamic-table">
                <thead>
                    <tr>
                    <th class="hidden-phone">{{ trans('admin.menu_name') }}</th>
                    <th> {{trans('admin.view') }}</th>
                    <th>{{trans('admin.insert') }}</th>
                    <th>{{trans('admin.update') }}</th>
                    <th>{{trans('admin.delete') }}</th>
                    </tr>
                </thead>
                <tbody>
                    <input type="hidden" value="{{$role->id}}" name="role_id">
                    @csrf
                    @foreach($menus as $item)

                                @if($item->parent_id == 0)
                                    <tr>
                                        <td>
                                            <span style="font-size:16px; ">{{$item->menu_name}}</span>
                                        </td>
                                        <td>
                                            @php $selected = (in_array('view '.$item->route,$permissions) == true ) ? "checked" : "";@endphp
                                            <label class="switch" for="view_checkbox_{{$item->id}}">
                                                <input class="" name="perm[]" value ="view {{$item->route}}" type="checkbox" id="view_checkbox_{{$item->id}}" {{$selected}} />
                                                <div class="slider round"></div>
                                            </label>
                                        </td>
                                         <td>
                                             @php $checked = (in_array('insert '.$item->route,$permissions) == true ) ? "checked" : "";@endphp
                                            <label class="switch" for="insert_checkbox_{{$item->id}}">
                                                <input name="perm[]" class="" value ="insert {{$item->route}}" type="checkbox" id="insert_checkbox_{{$item->id}}" {{$checked}} />
                                                <div class="slider round"></div>
                                            </label>
                                        </td>
                                        <td>
                                             @php $checked = (in_array('update '.$item->route,$permissions) == true ) ? "checked" : "";@endphp
                                            <label class="switch" for="update_checkbox_{{$item->id}}">
                                                <input name="perm[]" class="" value ="update {{$item->route}}" type="checkbox" id="update_checkbox_{{$item->id}}"  {{$checked}}/>
                                                <div class="slider round"></div>
                                            </label>
                                        </td>
                                        <td>
                                             @php $checked = (in_array('delete '.$item->route,$permissions) == true ) ? "checked" : "";@endphp
                                            <label class="switch" for="delete_checkbox_{{$item->id}}">
                                                <input name="perm[]" class="" value="delete {{$item->route}}" type="checkbox" id="delete_checkbox_{{$item->id}}" {{$checked}} />
                                                <div class="slider round"></div>
                                            </label>
                                        </td>
                                        <td colspan="3">
                                    </tr>
                                @endif
                                @if ($item->sub_menu)
                                @foreach($item->sub_menu as $value)
                                    <tr>
                                        <td>
                                            - - {{$value->menu_name}}
                                        </td>
                                        <td>
                                             @php $checked = (in_array('view '.$value->route,$permissions) == true ) ? "checked" : "";@endphp
                                            <label class="switch" for="view_checkbox_{{$value->id}}">
                                                <input name="perm[]" class="" value ="view {{$value->route}}" type="checkbox" id="view_checkbox_{{$value->id}}"  {{$checked}}/>
                                                <div class="slider round"></div>
                                            </label>
                                        </td>
                                        <td>
                                             @php $checked = (in_array('insert '.$value->route,$permissions) == true ) ? "checked" : "";@endphp
                                            <label class="switch" for="insert_checkbox_{{$value->id}}">
                                                <input name="perm[]" class="" value ="insert {{$value->route}}" type="checkbox" id="insert_checkbox_{{$value->id}}" {{$checked}} />
                                                <div class="slider round"></div>
                                            </label>
                                        </td>
                                        <td>
                                             @php $checked = (in_array('update '.$value->route,$permissions) == true ) ? "checked" : "";@endphp
                                            <label class="switch" for="update_checkbox_{{$value->id}}">
                                                <input name="perm[]" class="" value ="update {{$value->route}}" type="checkbox" id="update_checkbox_{{$value->id}}"  {{$checked}}/>
                                                <div class="slider round"></div>
                                            </label>
                                        </td>
                                        <td>
                                             @php $checked = (in_array('delete '.$value->route,$permissions) == true ) ? "checked" : "";@endphp
                                            <label class="switch" for="delete_checkbox_{{$value->id}}">
                                                <input name="perm[]" class="" value="delete {{$value->route}}" type="checkbox" id="delete_checkbox_{{$value->id}}" {{$checked}} />
                                                <div class="slider round"></div>
                                            </label>
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                    @endforeach
                </tbody>
            </table>
            <hr>
            <input type="submit" class="btn btn-primary btn-sm" value="Save">

        </form>


      </div>
    </div>
  </div>
</main>


@endsection
