@extends('admin.layout.master')
@section('content')
@include('admin/profile/profile_js')
<div class="container">
    <div class="row   justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  text-dark breadc' href="">
                Home / User Profile
            </a>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-8 offset-md-2">
            <section id="#personal_info">
                <div class="py-2">
                    <a href='#'class="bg-light_c rounded text-decoration-none p-1 text-dark">
                        Personel Info
                    </a>
                </div>
                <div class="card p-2 mt-l">
                    <form action="{{route('updateProfile')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="offset-4 col-4">
                            @if(session()->has('success'))
                                <div class="bg-success p-2 mt-4 rounded text-white">
                                    <span class="input-error">{{ session()->get('success') }}</span>
                                </div>
                            @elseif(session()->has('error'))
                                <div class="bg-danger p-2 mt-4 rounded text-white">
                                    <span class="input-error">{{ session()->get('error') }}</span>
                                </div>
                            @endif
                            <!-- @if ($errors->any())
                                <div class="bg-danger p-2 mt-4 rounded text-white">
                                    @foreach ($errors->all() as $message)
                                        <span class="input-error">{{ $message }}</span><br>
                                    @endforeach
                                </div>
                            @endif -->
                        </div>
                        <div class="col-md-8">
                            <input type="hidden" name="id" id="id" value="{{$user->id}}">
                            <div class="mb-3">
                                <label for="name" class="form-label label">Name</label>
                                <input type="text" class="form-control  rounded-pill bg-light_c @error('name') is-invalid @enderror" id="name" name="name" aria-describedby="emailHelp" placeholder='Name' value="{{$user->name}}">
                                @error('name') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="username" class="form-label label">Username</label>
                                <input type="text" class="form-control  rounded-pill bg-light_c @error('username') is-invalid @enderror" id="username" name="username" aria-describedby="emailHelp" placeholder='Username' value="{{$user->username}}">
                                @error('username') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label label">Email</label>
                                <input type="email" class="form-control  rounded-pill bg-light_c @error('email') is-invalid @enderror" name="email" id="email" aria-describedby="emailHelp" placeholder='Email' value="{{$user->email}}">
                                @error('email') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="mobile" class="form-label label">Mobile No</label>
                                <input type="text" class="form-control  rounded-pill bg-light_c @error('mobile') is-invalid @enderror" id="mobile" name="mobile" aria-describedby="emailHelp" placeholder='0333999' value="{{$user->mobile}}">
                                @error('mobile') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-warning col-bt rounded-pill mt-4 text-white">Update</button>
                        </div>
                        <div class="col-12 col-md-2">
                            <div class="container mt-lg-2 pt-3 ">
                                <label class="upload-btn-wrapper bg-light_c" for="file"> 
                                    <img src="{{ asset('project/profile/'.$user->photo) }}" class="img-fluid" alt="" id="preview">
                                    <span class=" p-1 text-start"><i class="bi bi-camera pe-1"></i>Click Here</span>
                                </label>
                                <input type="file" name="photo" id="file" class="d-none  bg-light_c" onchange="itemname(event)" />
                                @error('photo') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                        </div>
                    </div>
                    </form>
                </div>
            </section>
            <section id="#change_password">
                <div class="row mt-3">
                    <div class="col-12">
                        <div class="py-2">
                        <a href='#'class="bg-light_c rounded text-decoration-none p-1 mb-2 text-dark">
                        Change Password
                        </a>
                        </div>
                        <div class="card p-3 mb-3">
                        <div class="col-md-8">
                            <form action="{{route('resetPass')}}" method="POST">
                            @csrf
                            <input type="hidden" name="id" id="id" value="{{$user->id}}">
                            <div class="mb-3">
                                <div class="form-group">
                                    <label for="old_password">Old Password</label>
                                    <div class="input-group position-relative" id="show_hide_password">
                                    <input class="form-control rounded-pill bg-light_c @error('old_password') is-invalid @enderror" type="password" id="old_password" name="old_password">
                                    <div class="input-group-addon position-absolute text-end">
                                        <a class="ms-auto" href=""><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                                    </div>
                                    </div>
                                    @error('old_password') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-group">
                                    <label>New Password</label>
                                    <div class="input-group position-relative" id="show_hide_password2">
                                    <input class="form-control rounded-pill bg-light_c @error('password') is-invalid @enderror" type="password" id="password" name="password">
                                    <div class="input-group-addon position-absolute text-end">
                                        <a class="ms-auto" href=""><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                                    </div>
                                    </div>
                                    @error('password') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-group">
                                    <label>Confirm Password</label>
                                    <div class="input-group position-relative" id="show_hide_password3">
                                    <input class="form-control rounded-pill bg-light_c @error('password_confirmation') is-invalid @enderror" type="password" id="password_confirmation" name="password_confirmation">
                                    <div class="input-group-addon position-absolute text-end">
                                        <a class="ms-auto" href=""><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                                    </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                            <button type="submit" class="btn btn-warning col-bt rounded-pill mt-4 text-white d-inline">Update</button>
                            </div>
                            </form>
                        </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="#favourite_menu">
                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="py-2">
                            <a href='#'class="bg-light_c rounded text-decoration-none p-1 mb-2 text-dark">Add Favourite Menus</a>
                        </div>
                        <div class="card p-3 mb-3">
                        <div class="col-md-8">
                            <form action="{{route('favourite_menu')}}" method="POST">
                            @csrf
                            <input type="hidden" name="id" id="id" value="{{$user->id}}">
                            <div class="mb-3">
                                <label for="menu_id" class="form-label label">Menus</label>
                                <select id="menu_id"  name="menu_id[]" class="form-control rounded-pill bg-light_c @error('menu_id') is-invalid @enderror selectpicker w-100" multiple>
                                    @foreach($menus as $data)
                                        <option value="{{$data->id}}">
                                            @if (Session::get('locale') == 'ar')
                                                {{$data->menu_ar}}
                                            @else
                                                {{$data->menu_name}}
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('menu_id') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                            <div>
                            <button type="submit" class="btn btn-warning col-bt rounded-pill mt-4 text-white d-inline">Add</button>
                            </div>
                            </form>
                        </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<style type="text/css">
    .input-group-addon {
        right: 0% !important;
        padding: 7px;
        /* background-color: red; */
    }
    .text-decorat a{
        text-decoration: none;
        color: black;
    }
    ul.nav.nav-tab li a.active{
        background-color: #ffc107 !important;
        padding: .5rem !important;
        border-radius: .25rem !important;
    }
</style>
@endsection