@extends('admin.layout.master')
@section('content')
<div class='bg-white p-2 rounded '>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-9 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold ' href="{{url('/notification_template')}}">{{trans('admin.notifications_templates')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold ' href="{{url('/notification_template')}}">{{trans('admin.edit_notifications_templates')}}  </a> <span class="bi bi-caret-right"></span>
             <span class='text-decoration-none fw-bold' >{{$post->name}}</span> 
        </div>
    </div>
</div>
<div class="container-fluid  rounded border">
    <div class="row p-3 ">
    	<div class="col-12">
            @if(session()->has('success'))
                <div class="bg-success p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('success') }}</span>
                </div>
            @elseif(session()->has('error'))
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('error') }}</span>
                </div>
            @endif
            <!-- @if ($errors->any())
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    @foreach ($errors->all() as $message)
                        <span class="input-error">{{ $message }}</span><br>
                    @endforeach
                </div>
            @endif -->
        </div>
        <div class="col-md-9 pe-lg-5">
        <form action="{{route('update_notify_temp')}}" method="post">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <input type="hidden" name="id" id="id" value="{{$post->id}}">
            <div class="mb-3">
                <label class="label" for="name" class="form-label">{{ trans('admin.name') }}</label>
                <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('name') is-invalid @enderror"  id="name" name="name" placeholder="Name" aria-describedby="emailHelp" value="{{$post->name}}" readonly>
                @error('name') 
                    <span class="text-danger">{{ $message }}</span> 
                @enderror
            </div>
            <div class="mb-3">
                <label class="label" for="title" class="form-label">{{ trans('admin.title') }}</label>
                <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('title') is-invalid @enderror"  id="title" name="title" placeholder="{{ trans('admin.title') }}" aria-describedby="emailHelp" value="{{$post->title}}">
                @error('title') 
                    <span class="text-danger">{{ $message }}</span> 
                @enderror
            </div>       
            <div class="mb-3 position-relative">
                <label for="text">{{ trans('admin.description') }}</label>
                <textarea data-emojiable="true" data-emoji-input="unicode" class="form-control bg-light_c border-0 rounded cat @error('text') is-invalid @enderror"rows="10" placeholder={{ trans('admin.type_here') }}name="text">{{$post->text}}</textarea>
                <div class="position-absolute bottom-0 p-2"> 
                    <div class="btn-group rounded-pill border-0" role="group" aria-label="Basic example">
                        <button type="button" class="btn btn-info col-upload border-0" style=' background-color: transparent;'>
                            <i class="bi bi-image-fill"></i>
                            {{ trans('admin.photo') }}
                        </button>
                        <button type="button" class="btn btn-info col-upload border-0 epicker" data-type='picker' style=' background-color: transparent;'>
                            <i class="bi bi-emoji-smile-fill"></i>
                            {{ trans('admin.emoji') }}
                        </button>
                    </div>
                </div>
                @error('text') 
                    <span class="text-danger">{{ $message }}</span> 
                @enderror
            </div>
            <div class='d-flixs'>
                <button type="submit" class="btn btn-warning col-bt rounded-pill mb-4 mt-3 text-white">Update</button>
            </div>
        </form> 
        </div>
        <div class="col-md-3 bg-light_c p-3 rounded  g-2">
            <div class="container ">
            <i class="bi bi-question-circle-fill" style="font-size: 20px; padding-top:10px;"></i>
                <p class='fw-bold text-dark mt-2'>{{ trans('admin.parameters') }}</p>
                <p class='font_side'>{{ trans('admin.add_parameters_like_this') }}</p>
                <p>{{$post->params}}</p>
            </div>
        </div>
    </div>
</div>
<script>
// click indirectly on default emoji picker
$(".epicker").click(function(){
    $('.emoji-picker').click();
});
</script>
<link href="{{ asset('assets/plugins/emoji-picker/lib/css/emoji.css') }}" rel="stylesheet">
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/config.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/util.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/jquery.emojiarea.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/emoji-picker.js') }}"></script>

<script>
$(function () {
    // Initializes and creates emoji set from sprite sheet
    window.emojiPicker = new EmojiPicker({
        emojiable_selector: '[data-emojiable=true]',
        assetsPath: '{{ asset("assets/plugins/emoji-picker/lib/img/") }}',
        popupButtonClasses: ''
    });
    window.emojiPicker.discover();
});
</script>
@endsection