@extends('admin.layout.master')
@section('content')
<style>
    option {
        font-size: 12px !important;
    }
    .emoji-menu{
        top:0px;
    }
    .emoji-picker{
        display:none;
    }
</style>

<form action="{{route('send_notification')}}" method="post">
<input type="hidden" name="_token" value="{{ csrf_token() }}" />
<div class="container-fluid">
    <!-- <p class="emoji-picker-container">
        <textarea class="input-field" data-emojiable="true" data-emoji-input="unicode" type="text" name="comment" id="comment" placeholder="Add a Message">  </textarea>
    </p> -->
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="/home">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.send_multi_notifications')}}</span>  
            <div class='fs-5 float-end'>
                <a href=""> <i class="bi bi-stopwatch text-dark"></i> </a>
            </div>
        </div>
        <div class="col-12 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row gx-2">
                    <div class="col-md-3 col-sm-6">
                        <select id="users" class="form-select rounded-pill">
                            <option value="" selected> {{ trans('admin.all_users') }}</option>
								{!! getUserTypeList() !!}
                        </select>
                    </div>
                    <div class="col-md-4 col-sm-6">
                        <select id="languages" class="form-select rounded-pill">
                            <option value="" selected> {{ trans('admin.all_languages') }}</option>
                            <option value="en"> {{ trans('admin.english') }} </option>
                            <option value="ar"> {{ trans('admin.arabic') }} </option>
                        </select>
                    </div>
                    <div class="col-md-3 col-sm-6">
                        <select name="devices" id="devices" class="form-select rounded-pill">
                            <option value="" selected> {{ trans('admin.all_devices') }}</option>
                            <option value="android"> {{ trans('admin.android') }} </option>
                            <option value="ios"> {{ trans('admin.iOS') }} </option>
                        </select>
                    </div>
                    <div class="col-md-1 col-sm-6">
                        <button type="button" class="btn btn-secondary rounded-pill clear">{{ trans('admin.clear') }}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<section>
    <div class="container-fluid">
        <div class="row p-2">
            <div class="col-12">
                @if(session()->has('success'))
                    <div class="bg-success p-2 mt-4 rounded text-white">
                        <span class="input-error">{{ session()->get('success') }}</span>
                    </div>
                @elseif(session()->has('error'))
                    <div class="bg-danger p-2 mt-4 rounded text-white">
                        <span class="input-error">{{ session()->get('error') }}</span>
                    </div>
                @endif

                @if ($errors->any())
                    <div class="bg-danger p-2 mt-4 rounded text-white">
                        @foreach ($errors->all() as $message)
                            <span class="input-error">{{ $message }}</span><br>
                        @endforeach
                    </div>
                @endif
            </div>
            <div class="col-md-7 ">
                <table class="table table-sm table-responsive data-table">
                    <thead>
                        <tr class="align-middle">
                            <th class='text-secondary p-2'>
                                <label class="container1 p-2 ms-1">
                                    <input type="checkbox" class="check-all">
                                    <span class="checkmark"></span>
                                </label>
                            </th>
                            <th class="text-start">{{ trans('admin.user') }}</th>
                            <th class="text-start">{{ trans('admin.language') }}</th>
                            <th class='text-end'>{{ trans('admin.device') }}</th>
                        </tr>
                    </thead>
                    
                </table>
            </div>
            <!-- END 7 COL  -->
            <div class="col-md-5 pt-3 ">
                
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label label">{{ trans('admin.title') }}</label>
                    <input type="text" class="form-control rounded-pill bg-light_c @error('title') is-invalid @enderror" name="title" id="title" value="{{ old('title') }}">
                </div>
                <div class="mb-3">
                    <label for="hosts" class="form-label label">Hosts</label>
                    <select  id="hosts" class="form-select rounded-pill bg-light cat" name="hosts">
                        <option value="">Select</option>
                        @foreach(notification_host_list() as $host)
                            <option value="{{$host->id}}" @if($host->is_default == 1) selected @endif>{{$host->name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="mb-3">
                    <label for="template" class="form-label label">Templates</label>
                    <select  id="template" class="form-select rounded-pill bg-light cat" name="template">
                        <option value="">Select</option>
                        @foreach(notification_templates_list() as $temp)
                        <option value="{{$temp->id}}">{{$temp->name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="mb-3">
                    <div class="container bg-light p-2">
                        <i class="bi bi-question-circle-fill" style="font-size: 20px; padding-top:10px;"></i> <span class='fw-bold text-dark mt-2'>Parameters</span>
                        <p id="params"></p>
                    </div>
                </div>
                <div class="mb-3 position-relative">
                    <label for="exampleFormControlTextarea1" class="form-label label">{{ trans('admin.message') }}</label>
                    <textarea data-emojiable="true" data-emoji-input="unicode" class="form-control bg-light_c textarea-round cat @error('message') is-invalid @enderror" name="message" rows="8" placeholder="{{ trans('admin.type_here') }}" id="message"> {{ old('message') }}</textarea>
                    
                    <div class="btn-group position-absolute bottom-0 p-2" role="group" aria-label="Basic example">
                        <!-- <button type="button" class="btn btn-info col-upload border-0" style=' background-color: transparent;'>
                            <i class="bi bi-image-fill"></i> {{ trans('admin.photo') }}
                        </button> -->
                        <button type="button" class="btn btn-info col-upload border-0 epicker" data-type='picker' style=' background-color: transparent;'>
                            <i class="bi bi-emoji-smile-fill"></i> {{ trans('admin.emoji') }}
                        </button>
                    </div>
                </div>
                <div class="container text-center">
                    <p class='fs-6 fw-bold'>{{ trans('admin.total_receiver') }} : <span id="counter"></span> </p>
                    <div class='d-grid'>
                        <button class="btn btn-primary col-bt rounded-pill my-4" type="submit">{{ trans('admin.send') }}</button>
                    </div>
                </div>
                <!-- END 5 COL  -->
            </div>
        </div>
    </div>
    
</section>
</form>


<script type="text/javascript">
    var table = "";
    $(function() {
        table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ url('notification/get-list') }}",
                type: 'GET',
                data: function(d) {
                    d.user_filter = $('#users').val();
                    d.locale_filter = $('#languages').val();
                    d.device_filter = $('#devices').val();
                    // console.log(d);
                }
            },
            columns: [
                // {data: 'id', name: 'id'},
                {data: 'actions',name: 'actions',orderable: false},
                {data: 'name',name: 'name', searchable: true},
                {data: 'language',name: 'language'},
                {data: 'device',name: 'device'},
            ],
            "lengthMenu": [[100, 200, 500, 700, -1], [100, 200, 500, 700, "All"]]
        });
    });
    // $("#search_new").on("keyup search input paste cut", function() {
    //     table.search(this.value).draw();
    // });
    $('body').on('change', '#users, #languages, #devices', function(e) {
        table.draw(true);
    });
    $('body').on('click', '.clear', function(e) {
        $('#users').val("");
        $('#languages').val("");
        $('#devices').val("");
        table.draw(true);
    });
    // click indirectly on default emoji picker
    $(".epicker").click(function(){
        $('.emoji-picker').click();
    });
    // check all 
    $(".check-all").change(function (e) { 
        
        if ($(this).is(':checked')) {
            // $('.sub-check').attr('checked', 'checked');
            $('.sub-check').prop('checked', 'true');
            
        }else{
            // $('.sub-check').removeAttr('checked', 'checked');
            $('.sub-check').each(function (indexInArray, valueOfElement) { 
                if ($(this).is(":checked")) {
                    $(this).trigger('click');    
                }
                
            });
            
        }
        $('.sub-check').change();
    });
    $('body').on('change', '.sub-check', function (e) {
        var count = $('.sub-check').filter(':checked').length;
        $("#counter").html(count);
    });

    $('body').on('change','#template',function(e){
        e.preventDefault();
        loading('start');
        var id = $("#template").val();
        if (id != "") {
          $.ajax({
              url: '{{url("/notification/get_template")}}/'+id,
              type: 'get',
              dataType:'json',
          })
          .done(function (res) {
            $("#title").val(res.title);
            $("#params").html(res.params);
            $(".emoji-wysiwyg-editor").text(res.text);
          })
          .fail(function () {
            console.log("error");
          }).always(function(){
            loading("stop");
          });
        }
    });
</script>


<link href="{{ asset('assets/plugins/emoji-picker/lib/css/emoji.css') }}" rel="stylesheet">
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/config.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/util.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/jquery.emojiarea.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/emoji-picker.js') }}"></script>

<script>
$(function () {
    // Initializes and creates emoji set from sprite sheet
    window.emojiPicker = new EmojiPicker({
        emojiable_selector: '[data-emojiable=true]',
        assetsPath: '{{ asset("assets/plugins/emoji-picker/lib/img/") }}',
        popupButtonClasses: ''
    });
    window.emojiPicker.discover();
});
</script>

@endsection