@extends('admin.layout.master')
@section('content')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill fw-bold">{{ trans('admin.notification_host') }}</span>
            <span class="bi bi-caret-right fw-bold">{{$post->name}}</span>
        </div>
    </div>
</div>
<div class="container-fluid">
    <div class="row rounded border m-2 p-2">
    	<div class="col-12">
            @if(session()->has('success'))
                <div class="bg-success p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('success') }}</span>
                </div>
            @elseif(session()->has('error'))
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('error') }}</span>
                </div>
            @endif
            <!-- @if ($errors->any())
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    @foreach ($errors->all() as $message)
                        <span class="input-error">{{ $message }}</span><br>
                    @endforeach
                </div>
            @endif -->
        </div>
        <div class="col-md-5">
            <div>
                <form action="{{route('update_notify_hosts')}}" method="post">
                	<input type="hidden" name="_token" value="{{ csrf_token() }}" />
                    <input type="hidden" name="id" id="id" value="{{$post->id}}">
                    <div class="mb-3">
                        <label class="label" for="name" class="form-label">Heading</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('name') is-invalid @enderror"  id="name" name="name" placeholder="Name" aria-describedby="emailHelp" value="{{$post->name}}" readonly>
                        @error('name') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="label" for="serverkey" class="form-label">Server Key</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('serverkey') is-invalid @enderror"  id="serverkey" name="serverkey" placeholder="Name" aria-describedby="emailHelp" value="{{$post->serverkey}}">
                        @error('serverkey') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <br>
                    <!-- switch start  -->
                    <div class="d-flex justify-content-between mob_just">
                        <label for="status" class="ms-2 mb-1">Status</label>
                        <label class="switch">
                            <input type="checkbox" name="status" id="status" value="1" @if($post->status == 1) checked @endif>
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">on</span>
                                <span class="off">off</span>
                            </div>
                        </label>
                    </div> 
                    <!-- switch end  --><br>

                    <!-- switch start  -->
                    <div class="d-flex justify-content-between mob_just">
                        <label for="default" class="ms-2 mb-1">Default</label>
                        <label class="switch">
                            <input type="checkbox" name="default" id="default" value="1" @if($post->is_default == 1) checked @endif>
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">on</span>
                                <span class="off">off</span>
                            </div>
                        </label>
                    </div> 
                    <!-- switch end  --><br>
                    <button type='sumbit ' class='btn btn-success btn-color rounded-pill text-light px-5 mt-lg-3 mb-5'>Update</button>
                </form>
                <br>

            </div>
        </div>
    </div>
</div>
@endsection