@extends('admin.layout.master')
@section('content')
@include('admin/notification/script_js')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill fw-bold">{{ trans('admin.notification_host') }}</span>
            
        </div>
        <div class="col-12 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row">
                    <div class="col-12 col-md-7">
                        <div>
                        <input type="text" class="form-control rounded-pill bg-light" id="search_new" placeholder="{{trans('admin.search')}}">
                        </div>
                    </div>
                    <div class="col-12 col-md-4">
                        <div>
                        <select id="status_filter" class="form-select rounded-pill">
                          <option value="" selected> {{ trans('admin.status') }}</option>
                          <option value="1"> {{ trans('admin.active') }}</option>
                          <option value="0"> {{ trans('admin.inactive') }} </option>
                        </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class='table-responsive p-3'>
        <table class='table w-100 table-border data-table'>
            <thead>
                <tr class='tex-g'>
                    <th>{{ trans('admin.name') }}</th>
                    <th class='text-center pe-4'>{{ trans('admin.default') }}</th>
                    <th  class='text-center pe-4'>{{ trans('admin.status') }}</th>
                    <th class='text-center'>{{ trans('admin.actions') }}</th>
                </tr>
            </thead>
            <tbody>
                 
            </tbody>
        </table>
    </div>
</div>
<script type="text/javascript">
    var table = "";
    $(function() {
        table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            "searching": false,
            ajax: {
                url: "{{ route('notification_host') }}",
                type: 'GET',
                data: function(d) {
                  d.search_new = $('#search_new').val();
                  d.status_filter = $('#status_filter').val();
                  // console.log(d);
                }
            },
            columns: [
                {data: 'name', name: 'name'},
                {data: 'is_default', name: 'is_default', orderable: false, searchable: false},
                {data: 'status', name: 'status', orderable: false, searchable: false},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ],
            "lengthMenu": [[10, 25, 50, 100, -1], [100, 200, 500, 700, "All"]]
        });
    });
    $('body').on('change', '#status_filter', function(e) {
      table.draw(true);
    });
    $('body').on('keyup', '#search_new', function(e) {
      table.draw(true);
    });
    $('body').on('click', '.clear', function(e) {
        $('#search_new').val("");
        $('#status_filter').val("");
        table.draw(true);
    });
</script>
@endsection