@extends('admin.layout.master')
@section('content')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold' href="{{url('/pages')}}" >{{trans('admin.pages')}}</a><span class="bi bi-caret-right"></span>
            <span> @if(Auth::user()->locale == 'en') {{$page_name = $post->name_en}} @else {{$page_name = $post->name_ar}} @endif</span>
            
        </div>
    </div>
</div>
<div class="container-fluid">
    <div class="row rounded border m-2 p-2">
        <div class="col-md-12">
            @if(session()->has('success'))
                <div class="bg-success p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('success') }}</span>
                </div>
            @elseif(session()->has('error'))
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('error') }}</span>
                </div>
            @endif
        </div>
        <div class="col-md-12">
            <div>
                <form action="{{route('pages_update')}}" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                    <input type="hidden" name="id" id="id" value="{{$post->id}}">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="name" class="form-label">{{trans('admin.page_name')}}</label>
                                <input type="text" class="form-control rounded-pill bg-light_c border-0" id="name" name="name" placeholder="{{trans('admin.page_name')}}" aria-describedby="emailHelp" value="{{$page_name}}" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="title_en" class="form-label">{{trans('admin.title_en')}}</label>
                                <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('title_en') is-invalid @enderror" id="title_en" name="title_en" placeholder="{{trans('admin.title')}}" aria-describedby="emailHelp" value="{{$post->title_en}}">
                                @error('title_en') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="title_ar" class="form-label">{{trans('admin.title_ar')}}</label>
                                <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('title_ar') is-invalid @enderror" id="title_ar" name="title_ar" placeholder="{{trans('admin.title')}}" aria-describedby="emailHelp" value="{{$post->title_ar}}">
                                @error('title_ar') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="username" class="form-label">{{trans('admin.content_en')}}</label>
                                <textarea id="text_en" name="text_en" class="form-control bg-light_c border-0 rounded cat @error('text_en') is-invalid @enderror" rows="12" placeholder="{{trans('admin.content_en')}}">{!!$post->content_en!!}</textarea>
                                @error('text_en') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="username" class="form-label">{{trans('admin.content_en')}}</label>
                                <textarea id="text_ar" name="text_ar" class="form-control bg-light_c border-0 rounded cat @error('text_ar') is-invalid @enderror" rows="12" placeholder="{{trans('admin.content_en')}}">{!!$post->content_ar!!}</textarea>
                                @error('text_ar') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-12">
                            <!-- switch start  -->
                            <div class="d-flex  mob_just pt-2 my-3">
                                <label for="status" class="ms-2 mb-1">{{ trans('admin.status') }}</label>
                                <label class="switch ms-5">
                                    <input type="checkbox" name="status" id="status" value="1" @if($post->status == 1) checked @endif>
                                    <div class="slider round">
                                        <!--ADDED HTML -->
                                        <span class="on">{{ trans('admin.on') }}</span>
                                        <span class="off">{{ trans('admin.off') }}</span>
                                    </div>
                                </label>
                            </div>
                            <!-- switch end  -->
                            <button type='sumbit' class='btn btn-success btn-color rounded-pill text-light px-5 mt-lg-3 my-2'>{{ trans('admin.update') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    CKEDITOR.replace('text_en');
    CKEDITOR.replace('text_ar');
</script>
@endsection
