@php
    $sidebar = DB::table('menus')
    ->select('id','menu_name','menu_ar','route','icon')
    ->where('type','2')
    ->where('status','1')
    ->where('parent_id',0)
    ->orderBy('order_by', 'ASC')
    ->get();
	
    foreach ($sidebar as $key => $value) {
        $sub_menu = DB::table('menus')->where(['status' => '1','parent_id' => $value->id]);
       $sidebar[$key]->sub_menu = json_decode(json_encode($sub_menu->get()),true);
	 
		
    }
    $route = explode('/',Request::path());
    $getCurrentPageMenuDetail = DB::table('menus')->where('route','=','/'.$route[0]);
    $getCurrentPageMenuDetail = $getCurrentPageMenuDetail->first() ;

    $routes = DB::table('menus')->select('route')->pluck('route');
    $routes = json_decode(json_encode($routes),true);
    // $activeClass = (in_array("/".Request::path(), $routes)) ? "active" : "";
    $activeClass = $showDIV = "";
@endphp
<nav id="sidebar" class="">
    <div class="custoggle">
        <button type="button" id="sidebarCollapse" class="btn">
            <i class='bi-chevron-double-left' style='font-size:1em;line-height:0;'></i>
        </button>
    </div>
    <div class="sidebar-header align-items-center">
        <a class="page" href="{{ url('/') }}">
            <img src="{{asset(getSiteInfo('photo'))}}" class="img-fluid px-2 pt-2" id="erp-logo" alt="Sharpvisions">
        </a>
    </div>
    <div class="overflo">
        <ul class="list-unstyled components">

            <li class="active">
                <a class="page" href="{{ url('/home') }}">
                    <i class='bi-grid-fill me-1' style='font-size:1em;line-height:0;'></i>
                    {{trans('admin.dashboard')}}
                </a>
            </li>

            @foreach ($sidebar as $item)

                @if (!count($item->sub_menu) > 0)
                    @can('view '.$item->route)
                    <li class="{{$activeClass}}">
                        <a class="page" href="{{ url($item->route) }}">
                        <i class="bi-{{$item->icon}} me-1" style='font-size:1em;line-height:0;'></i>
							@if (Session::get('locale') == 'ar')
                                {{$item->menu_ar}}
                            @else
                                {{$item->menu_name}}
                            @endif
                        </a>
                    </li>
                    @endcan
                @else
                    @can('view '.$item->route)
                    @if (isset($getCurrentPageMenuDetail->parent_id) && $getCurrentPageMenuDetail->parent_id > 0)
                        @php
                            $activeClass = ((Request::path() != 'home' && Request::path() != "profile") && $getCurrentPageMenuDetail->parent_id == $item->id) ? "active" : "";
                            $showDIV = ((Request::path() != 'home' && Request::path() != "profile") && $getCurrentPageMenuDetail->parent_id == $item->id) ? "style=display:block" : "";
                        @endphp
                    @endif
                    <li class="{{$activeClass}}">
                        <button class="dropdown-btn {{$activeClass}}">
                            <i class="bi-{{$item->icon}} me-1" style='font-size:1em;line-height:0;'></i>
                            @if (Session::get('locale') == 'ar')
                                {{$item->menu_ar}}
                            @else
                                {{$item->menu_name}}
                            @endif
                            <i class="bi bi-caret-down-fill float-end"></i>
                        </button>
                        <div class="dropdown-container" {{$showDIV}}>
                            @foreach ($item->sub_menu as $val)
                                @can('view '.$item->route)
                                    <a href="{{url($val['route'])}}">
                                        <i class="bi-{{$val['icon']}} me-1" style='font-size:1em;line-height:0;'></i>
                                        @if (Session::get('locale') == 'ar')
                                            {{$val['menu_ar']}}
                                        @else
                                            {{$val['menu_name']}}
                                        @endif
                                    </a>
                                @endcan
                            @endforeach
                        </div>
                    </li>
                    @endcan
                @endif
            @endforeach
            
            {{-- quick links for favourite menus --}}
            @php
                $favMenus = DB::table('favourite_menus')->whereUser_id(Auth::user()->id)->pluck('menu_id');
                $sidebarFavourite = DB::table('menus')
                ->select('id','menu_name','menu_ar','route','icon')
                ->where('status','1')
                ->whereIn('id',$favMenus)
                ->orderBy('order_by', 'ASC')
                ->get();
            @endphp
            <li class="active">
                <button class="dropdown-btn">
                    <i class="bi bi-activity me-1" style='font-size:1em;line-height:0;'></i>
                    {{trans('Quick_Links')}}
                    <i class="fas fa-sort-down"></i>
                </button>
                <div class="dropdown-container">
                    @foreach ($sidebarFavourite as $val)
                        @can('view '.$val->route)
                            <a href="{{url($val->route)}}">
                                <i class="bi-{{$val->icon}} me-1" style='font-size:1em;line-height:0;'></i>
                                @if (Session::get('locale') == 'ar')
                                    {{$val->menu_ar}}
                                @else
                                    {{$val->menu_name}}
                                @endif
                            </a>
                        @endcan
                    @endforeach
                </div>
            </li>
        </ul>
    </div>

    <div class="position-absulote bottom-0 text-center small w-100 my-2 ">
        <p class="">
            {{trans('admin.Copyright')}} 2021 &copy; <a href="https://said.com.sa" target="_blank"> Said Technology</a>
        </p>
    </div>
</nav>
