@extends('admin.layout.master')
@section('content')
<style>

</style>

    <div class="row justify-content-between rounded bg-light p-2 m-2">
        <div class="col-12 align-self-center">
            <a class='text-decoration-none fw-bold' href="/home">Home  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold' href="/languages">Languages</a> <span class="bi bi-caret-right"></span>

            <select name="abbr" class="rounded-pill bg-light" id="lang">
                @foreach ($languages as $lang)
                    @if($lang->abbr == @Request::segment(3))
                        <option value="{{$lang->abbr}}" selected>{{$lang->name}} ({{$lang->abbr}})</option>
                    @else
                        <option value="{{$lang->abbr}}">{{$lang->name}} ({{$lang->abbr}})</option>
                    @endif
                @endforeach
            </select>

        </div>
    </div>

    <div class="row justify-content-between rounded bg-light p-2 m-2 mb-0">
        <nav class="navbar navbar-expand-lg navbar-light bg-light">
            <a class="navbar-brand fs-6 fw-bold" href="#"> <i class="bi bi-file-earmark-medical me-1"></i> Files:</a>
            <button class="navbar-toggler"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#navbarNav"
                    aria-controls="navbarNav"
                    aria-expanded="false"
                    aria-label="Toggle navigation"
            >
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                @foreach ($langFiles as $file)
                    <li class="nav-item{{ $file['active'] ? ' active' : '' }}">
                        <a class="nav-link" href="{{ route('translation', $file['params']) }}">
                            {{ $file['name'] }}
                            @if ($file['active'])
                            <span class="sr-only">(current)</span>
                            @endif
                        </a>
                    </li>
                @endforeach
                </ul>
            </div>
        </nav>
    </div>

    <div class="row justify-content-center">
        <div class="col-12">
            <div class="bg-light p-2 m-2 rounded">
                <span class="bi bi-info-circle-fill me-2 fs-4"></span>
                Help text here
            </div>
            @if(session()->has('successMsg'))
                <div class="bg-success p-2 mx-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('successMsg') }}</span>
                </div>
            @elseif(session()->has('errorMsg'))
                <div class="bg-danger p-2 mx-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('errorMsg') }}</span>
                </div>
            @endif

            @if ($errors->any())
            <div class="bg-danger p-2 mx-2 mt-4 rounded text-white">
                @foreach ($errors->all() as $message)
                    <span class="input-error">{{ $message }}</span><br>
                @endforeach
            </div>

            @endif


            <form method="post" action="{{ route('save_translation', [@Request::segment(3), @Request::segment(4)])}}" class="mx-2 mb-4 rounded border">
                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                <div class="row px-4 p-4 g-4">
                    <div class="col-md-6 col-sm-12">
                        <label for="name" class=" mb-1 h6 fw-bold">Key</label>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <label for="datetime_format" class="ms-2 mb-1 h6 fw-bold">Translation</label>
                        <span class="small ms-2">Dont change <a class="text-decoration-none" href="javascript: void(0);">:attibute</a> in translation.</span>
                    </div>
                </div>
                <div class="container">
                    {!! $langFile->displayInputs($translation) !!}
                </div>
                <div class="row mb-2 p-4 g-4">

                    <div class="col-12 text-end">
                        <hr>
                        <button type="submit" class="btn btn-primary">
                            <span class="bi bi-check-circle me-2"></span> Save
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
    $("#lang").change(function (e) {
        var lang =
        url = "{{ route('translation', ['11aa', @Request::segment(4)])}}";
        nurl = url.replace('11aa', $(this).val());

        window.location.href = nurl

    });
</script>
@endsection
