@extends('admin.layout.master')
@section('content')
<style>
    input[type='checkbox'][readonly]{
    pointer-events: none;
}
</style>
    <div class='bg-white rounded'>
        <div class="row justify-content-between rounded bg-light p-2 m-2">
            <div class="col-md-6 col-sm-12 align-self-center">
                <a class='text-decoration-none fw-bold text-dark' href="/home">Home</a> <span class="bi bi-caret-right"></span> Languages
            </div>
            <div class="col-md-6 col-sm-12 text-end">
                <a href="{{route('translation', ['en','validation'])}}" class="btn btn-outline-primary rounded-pill me-3"> Translation </a>
                <a class='text-decoration-none' href="language/create">
                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 55 55">
                        <g id="Group_12506" data-name="Group 12506" transform="translate(-1134.648 -427.545)">
                        <ellipse id="Ellipse_593" data-name="Ellipse 593" cx="27.5" cy="27.5" rx="27.5" ry="27.5" transform="translate(1134.648 427.545)" fill="#f56a20"/>
                        <path id="Path_15415" data-name="Path 15415" d="M1.438-6.844V-9.469H8.25v-6.859h2.672v6.859h6.813v2.625H10.922V0H8.25V-6.844Z" transform="translate(1153.017 463.249)" fill="#fff"/>
                        </g>
                    </svg>
                </a>
            </div>
            
        </div>
        <div class='table-responsive m-2'>
            <table class='table table-border'>
                <thead>
                    <tr class='tex-g'>
                        <th>Language</th>
                        <th>Code</th>
                        <th>Direction</th>
                        <th>Active</th>
                        <th>Default</th>
                        <th class='text-end'>Actions</th>
                    </tr>
                </thead>
                <tbody>
                @empty($data)
                    <tr>
                        <th colspan="6" class="text-center">Data not found</th>
                    </tr>
                @endempty
                @foreach ($data as $language)
                    
                    <tr class="align-middle">
                        <td>
                            <sapn class='fw-bold text-dark'>{{$language->name}}</sapn><br>
                        </td>
                        <td class="text-uppercase">
                            {{$language->abbr}}
                        </td>
                        <td class="text-uppercase">
                            {{$language->direction}}
                        </td>
                        <td>
                            @if($language->status)
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="true" checked readonly>
                                </div>
                            @else
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault" checked disabled>
                                </div>
                            @endif
                            
                        </td>
                        <td>
                            @if($language->is_default)
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="true" checked readonly>
                                </div>
                            @else
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault" checked disabled>
                                </div>
                            @endif
                            
                        </td>
                        <td class='text-lg-end'>
                            <span>
                                <a class='text-decoration-none px-1' href="language/edit/{{$language->id}}"> 
                                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 40 40">
                                        <g id="Group_12735" data-name="Group 12735" transform="translate(-1068 -252)">
                                            <g id="Group_12512" data-name="Group 12512" transform="translate(-44 -88)">
                                            <circle id="Ellipse_598" data-name="Ellipse 598" cx="20" cy="20" r="20" transform="translate(1112 340)" fill="#edebf7"/>
                                            <path id="Icon_feather-edit-2" data-name="Icon feather-edit-2" d="M11.051,3.7A1.518,1.518,0,0,1,13.2,5.849L5.952,13.1,3,13.9l.805-2.952Z" transform="translate(1123.834 351.421)" fill="none" stroke="#543ab2" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                            </g>
                                        </g>
                                    </svg><span class='px-1'>Edit</span>
                                </a>
                            </span>
                            
                        </td>
                    </tr> 
                    @endforeach  
                </tbody>
            </table>
        </div>
    </div>
@endsection

