@extends('admin.layout.master')
@section('content')
        <div class="row justify-content-between rounded bg-light p-2 m-2">
        <div class="col-12 align-self-center">
            <a class='text-decoration-none fw-bold' href="/home">Home  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold' href="/languages">Languages</a> <span class="bi bi-caret-right"></span> New
        </div>
    </div>
    <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10 col-sm-12">
            <div class="bg-light p-2 mx-2 mt-4 rounded">
                <span class="bi bi-info-circle-fill me-2 fs-4"></span>
                Help text here
            </div>
            @if(session()->has('successMsg'))
                <div class="bg-success p-2 mx-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('successMsg') }}</span>
                </div>
            @elseif(session()->has('errorMsg'))
                <div class="bg-danger p-2 mx-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('errorMsg') }}</span>
                </div>
            @endif
            @if ($errors->any())
            <div class="bg-danger p-2 mx-2 mt-4 rounded text-white">
                @foreach ($errors->all() as $message)
                    <span class="input-error">{{ $message }}</span><br>
                @endforeach
            </div>
            @endif
            <form method="post" action="store" class="mx-2 my-4 rounded border">
                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                <div class="row my-2 p-4 g-4">
                    <div class="col-md-6 col-sm-12">
                        <label for="abbr" class="ms-2 mb-1">Language</label>
                        <select name="abbr" class="form-select rounded-pill bg-light @error('abbr') is-invalid @enderror">
                            <option value="">-</option>
                            @foreach ($languages as $abbr => $language)
                                <option value="{{$abbr}}">{{$language}} ({{$abbr}})</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <label for="name" class="ms-2 mb-1">Name</label>
                        <input type="text" name="name" class="form-control rounded-pill bg-light @error('name') is-invalid @enderror" placeholder="-">
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <label for="direction" class="ms-2 mb-1">Direction</label>
                        <select name="direction" class="form-select rounded-pill bg-light @error('direction') is-invalid @enderror">
                            <option value="">-</option>
                            <option value="ltr">LTR (Left to Right)</option>
                            <option value="rtl">RTL (Right to Left)</option>
                        </select>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <label for="flag" class="ms-2 mb-1">Flag</label>
                        <select name="flag" class="form-select rounded-pill bg-light" disabled>
                            <option value="">-</option>
                            @foreach ($languages as $abbr => $language)
                                <option value="{{$abbr}}">{{$language}} ({{$abbr}})</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <label for="date_format" class="ms-2 mb-1">Date Format</label>
                        <input type="text" name="date_format" class="form-control rounded-pill bg-light" placeholder="-">
                        <div class="form-text ms-2">Accepted format <a class="text-decoration-none" href="javascript: void(0);">ISO</a> patterns.</div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <label for="datetime_format" class="ms-2 mb-1">Date Time Format</label>
                        <input type="text" name="datetime_format" class="form-control rounded-pill bg-light" placeholder="-">
                        <div class="form-text ms-2">Accepted date format <a class="text-decoration-none" href="javascript: void(0);">ISO</a> patterns.</div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="d-flex justify-content-between">
                            <label for="status" class="ms-2 mb-1">Language Status</label>
                            <label class="switch">
                                <input type="checkbox" name="status" id="status" value="1" checked>
                                <div class="slider round">
                                    <!--ADDED HTML -->
                                    <span class="on">Active</span>
                                    <span class="off">Inactive</span>
                                </div>
                            </label>
                        </div> 
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="d-flex justify-content-between">
                            <label for="default" class="ms-2 mb-1">Default Status</label>
                            <label class="switch">
                                <input type="checkbox" name="default" id="default" value="1">
                                <div class="slider round">
                                    <!--ADDED HTML -->
                                    <span class="on">Active</span>
                                    <span class="off">Inactive</span>
                                </div>
                            </label>
                        </div> 
                    </div>
                    <div class="col-12 text-end">
                        <hr>
                        <button type="submit" class="btn btn-primary">
                            <span class="bi bi-check-circle me-2"></span> Save
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection