@extends('admin.layout.master')
@section('content')
<div class="container-fluid">
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill theme_text_color"></span>
            <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/frontend')}}">{{trans('admin.front_end')}}</a><span class="bi bi-caret-right theme_text_color"></span><span class='text-decoration-none fw-bold theme_text_color' >{{$section}}</span>
        </div>
    </div>
    <form action="{{url('frontend/update')}}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="section" value="{{$section}}">
        <div class="card p-3 m-2">
            <div class="row flex-column-reverse flex-lg-row">
                <div class="col-sm-6">
                    {{-- <div class="row mb-2">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="language">{{ trans('admin.select_language') }}</label>
                                <select name="language" id="" class="form-select rounded-pill bg-light_c @error('language') is-invalid @enderror">
                                    <option value="">{{ trans('admin.select') }}</option>
                                    @foreach ($language as $item)
                                        @php
                                            $selected = ($item->abbr == $default) ? "selected" : "";
                                        @endphp
                                        <option value="{{$item->abbr}}" {{$selected}}>{{$item->name}}</option>
                                    @endforeach
                                </select>
                                <small class="text-danger">@error('langugage') {{$message}} @enderror </small>

                            </div>
                        </div>
                    </div> --}}
                    <div class="row">
                        <div class="col-6">
                            <div class="mb-3">
                                <div class="form-group">
                                        <label for="exampleInputEmail1" class="form-label label">{{ trans('admin.text_color') }}</label>
                                        <input type="color" class="form-control @error('text_color') is-invalid @enderror form-control-color" name="text_color"  id="exampleColorInput" value="{{$data['colors']['text_color']}}" title="Choose your color">
                                </div>
                            <small class="text-danger">@error('text_color') {{$message}} @enderror </small>
                            </div>
                            <div class="mb-6">
                                <div class="form-group">
                                    <label for="exampleInputPassword1" class="form-label label">{{ trans('admin.background_heading_color') }}</label>
                                    <input type="color" class="form-control  @error('background_color') is-invalid @enderror form-control-color"  name="background_color" id="exampleColorInput" value="{{$data['colors']['background_color']}}" title="Choose your color">
                                </div>
                                <small class="text-danger"> @error('background_color') {{$message}} @enderror </small>

                            </div>
                        </div>
                    </div>

                <!-- this padding exctra  -->
                <div class='m-lg-5 p-lg-4'></div>
                </div>
                <div class="col-6 col-md-3 my-sm-4 margin">
                    <div class="container">
                        <label class="upload-btn-wrapper bg-light_c" for="file"> <span class="text_img">{{ trans('admin.photo') }}</span>
                            <img src="{{asset($data['photo'])}}" class="img-fluid" alt="" id="preview">
                        </label>
                        <input type="file"  name="photo" id="file" class="d-none" onchange="previewa(event)" />
                    </div>
                    <small class="text-danger"> @error('photo') {{$message}} @enderror </small>
                </div>
                <div class="row">
                    <div class="col-3 text-left">
                        <button type="submit" class="btn btn-warning col-bt rounded-pill text-white">{{ trans('admin.update') }}</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
</div>

@endsection
@section('custom-js')

<script>
    function previewa(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@include('admin.frontend.frontendJS')
@endsection
