@extends('admin.layout.master')
@section('content')
<div class="container-fluid mx-3 m-2">
    <div class="row   justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  theme_link_color' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill theme_text_color"></span>
            <a class='text-decoration-none fw-bold  theme_link_color' href="{{url('/frontend')}}">{{trans('admin.front_end')}}</a><span class="bi bi-caret-right theme_text_color"></span><span class='text-decoration-none fw-bold theme_text_color' >{{$section}}</span>
        </div>
    </div>

    <div class="card p-3 m-2 mt-3">
        @php
            if(@Request::segment(4) != '' ){
                $default = @Request::segment(4);

            }
        @endphp
        @if (session()->has('success'))
            <div class="alert alert-success">
            {{session()->get('success')}}

            </div>
        @endif
        <form method="post" action="{{url('frontend/update')}}" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="section" value="{{$section}}">
            <div class="row mb-2">
                <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                    <label for="language">{{ trans('admin.select_language') }}</label>
                </div>
                <div class="col-sm-6 col-md-9 offset-md-1">
                    <select name="language" id="language" class="form-control @error('language') is-invalid @enderror">
                        <option value="">{{ trans('admin.select') }}</option>
                        @foreach ($language as $item)
                            @php
                                $selected = ($item->abbr == $default) ? "selected" : "";
                            @endphp
                            <option value="{{$item->abbr}}" {{$selected}}>{{$item->name}}</option>
                        @endforeach
                    </select>
                    <small class="text-danger">@error('langugage') {{$message}} @enderror </small>
                    <hr class="bg-secondary">
                </div>
            </div>
            @php
                if(!isset($data['heading'][$default])){
                    $default = 'en';
                }
            @endphp
            <div class="row">
                <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                    <label for="">{{ trans('admin.background_color') }}</label>
                </div>
                <div class="col-sm-6 col-md-9 offset-md-1">

                    <input type="color" class="form-control  @error('background_color') is-invalid @enderror form-control-color" name="background_color"  id="exampleColorInput" value="{{$data['colors']['background_color']}}" title="Choose your color">
                    <hr class="bg-secondary">
                </div>
            </div>
            <div class="row d-none">
                <div class="col-4 d-none">
                    <div class="form-group">
                        <label for="">{{ trans('admin.text_color') }}</label>
                        <input type="color" class="form-control  @error('text_color') is-invalid @enderror form-control-color" name="text_color"  id="exampleColorInput" value="{{$data['colors']['text_color']}}" title="Choose your color">

                    </div>
                </div>
                <div class="col-4 d-none">
                    <div class="form-group">
                        <label for="">{{ trans('admin.heading_color') }}</label>
                        <input type="color" class="form-control  @error('heading_color') is-invalid @enderror form-control-color" name="heading_color"  id="exampleColorInput" value="{{$data['colors']['heading_color']}}" title="Choose your color">
                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                    <label for="exampleInputEmail1" class="form-label">{{ trans('admin.sub_heading') }}</label>
                </div>
                <div class="col-sm-6 col-md-9 offset-md-1">
                    <textarea type="text" class="form-control @error('sub_heading') is-invalid @enderror rounded bg-light_c" id="sub_heading" name= "sub_heading">{{$data['sub_heading'][$default]}}</textarea>
                    @error('sub_heading')
                        <small class="text-danger">{{$message}}</small>
                    @enderror
                    <hr class="bg-secondary">
                </div>
            </div>

            <div class="row">
                <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                    <label for="exampleFormControlTextarea1" class="form-label">{{ trans('admin.heading') }}</label>
                </div>
                <div class="col-sm-6 col-md-9 offset-md-1">
                    <textarea type="text" class="form-control @error('heading') is-invalid @enderror rounded bg-light_c" id="heading" name= "heading">{{$data['heading'][$default]}}</textarea>
                    @error('heading')
                        <small class="text-danger">{{$message}}</small>
                    @enderror
                    <hr class="bg-secondary">
                </div>
            </div>

            <div class="row">
                <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                    <label for="exampleFormControlTextarea3" class="form-label">{{ trans('admin.gallery') }}</label>
                </div>
                <div class="col-sm-6 col-md-9 offset-md-1">
                    <div class="upload-btn-wrapper bg-light w-100" style="background-color: transparent; height:57px; width:200px;">
                        <button class="border-0 mt-4" style=' background-color: transparent; color:rgba(84, 58, 178, 1);'>
                            {{ trans('admin.click_drop_upload') }}
                        </button>
                        <input type="file" id="file-input" name="slider[]" accept="image/png, image/jpeg" onchange="previewa()" multiple>
                    </div>
                    <p id="num-of-files">{{ trans('admin.no_file_choosen') }}</p>

                    <div class="row my-2" id="current_images">
                        @foreach ($data['photos'] as  $photo)
                        <div class='col-2 shadow-sm p-0 mx-2 my-2 overflow-hidden' style='height:200px;''>
                                <span data-id = "{{str_replace("/","-",$photo)}}" data-section = {{$section}} class='position-absolute remove-img' style='margin:-15px 0px 0px -10px;cursor:pointer'><i class='bi bi-x-circle-fill text-danger fs-5 position-absolute'></i></span>
                                <img class='img-fluid rounded shadow-sm' src='{{asset($photo)}}'> <small></small>
                            </div>
                        @endforeach
                    </div>

                    <div class="row my-2" id="images"></div>

                </div>
            </div>

            <div class="row">
                <div class="col-12 text-md-end text-center">
                    <button type="submit" class="btn btn-warning col-bt rounded-pill text-white">{{ trans('admin.update') }}</button>
                </div>
            </div>
            <!-- row ended here  -->

        </form>
    </div>
</div>
<style>
    .form-control,
    .cat {
        font-size: 14px;
        color: #383838;
    }

</style>

<script>
    CKEDITOR.replace( 'sub_heading' );
    CKEDITOR.replace( 'heading' );
    function itemname(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }

    function multi(event) {
        var preview = document.getElementById("pre");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }

    let fileInput = document.getElementById("file-input");
    let imageContainer = document.getElementById("images");
    let numOfFiles = document.getElementById("num-of-files");

    function previewa() {
        try {

            imageContainer.innerHTML = "";
            numOfFiles.textContent = fileInput.files.length + 'Files Selected';

            for (i of fileInput.files) {
                let reader = new FileReader();
                reader.onload = () => {
                    // console.log(i);
                    imageContainer.innerHTML += "\
                        <div class='col-2 img-div shadow-sm p-0 mx-2 my-2 overflow-hidden' style='height:200px;''>\
                            <span data-id='0' class='position-absolute remove-img' style='margin:-15px 0px 0px -10px; cursor:pointer;'><i class='bi bi-x-circle-fill text-danger fs-5 position-absolute'></i></span>\
                            <img class='img-fluid rounded shadow-sm' src='"+reader.result+"'> \
                        </div>\
                    ";
                }

                reader.readAsDataURL(i);
            }
        } catch (error) {
            console.log(error);
        }
    }

    // function removeFile(index) {
    //     // console.log("Test = "+index);
    //     // var a = $(this).text() ;
    //     // alert(a);
    //    $(this).closest('.img-div').remove();
    // }
    $('body').on('click','.remove-img',function () {
        let  item_id = $(this).data('id');
        let  section = $(this).data('section');

        if(!item_id == 0){
            try {

                 loading();
                    $.ajax({
                        url: '{{url("/frontend/delete-slider")}}/'+item_id+"/"+section,
                        type: 'get',
                    })
                    .done(function(response) {
                        // console.log(response);
                        loading("stop");
                        // swal(response.text.response.cls);

                    })
                    .fail(function() {
                        console.log("error");
                    })
                    .always(function() {
                        loading("stop");
                    });

            } catch (error) {
                loading("stop");
                console.log(error);
            }
        }
        $(this).parent().remove();
    });

    $("#language").change(function(){
        url = "{{'/'.@Request::segment(1).'/'.@Request::segment(2).'/'.@Request::segment(3).'/'}}"+$(this).val();
        window.location.href = url
    })

</script>
@endsection
