@extends('admin.layout.master')
@section('content')
<div class="row justify-content-between rounded bg-light p-2 m-2">
    <div class="col-12 align-self-center">
        <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill theme_text_color"></span>
        <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/frontend')}}">{{trans('admin.front_end')}}</a><span class="bi bi-caret-right theme_text_color"></span><span class='text-decoration-none fw-bold theme_text_color' >{{$section}}</span>
    </div>
</div>
<div class="container-fluid">

    <br>
    <form action="{{url('frontend/update')}}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="section" value="{{$section}}">
        <div class="card p-3 m-2">
            @php
                if(@Request::segment(4) != '' ){
                    $default = @Request::segment(4);

                }
            @endphp
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{session()->get('success')}}
                </div>
            @endif
            <div class="row">
                <div class="col-sm-9">
                    <div class="row mb-2">
                        <div class="col-sm-6 col-md-2 text-end fw-bold">
                            <div class="form-group">
                                <label for="language">{{ trans('admin.select_language') }}</label>

                            </div>
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            <select name="language" id="language" class="form-select @error('language') is-invalid @enderror">
                                <option value="">{{ trans('admin.select') }}</option>
                                @foreach ($language as $item)
                                @php
                                $selected = ($item->abbr == $default) ? "selected" : "";
                                @endphp
                                <option value="{{$item->abbr}}" {{$selected}}>{{$item->name}}</option>
                                @endforeach
                            </select>
                            <small class="text-danger">@error('language') {{$message}} @enderror </small>
                            <hr class="bg-secondary">
                        </div>
                    </div>
                    @php
                        if(!isset($data['privacy_policy']['name'][$default])){
                            $default = 'en';
                        }
                    @endphp
                    <div class="row">
                        <div class="col-3">
                            <div class="mb-3">
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="form-label label">{{ trans('admin.text_color') }}</label>
                                    <input type="color" class="form-control  @error('text_color') is-invalid @enderror form-control-color" name="text_color" id="exampleColorInput" value="{{$data['colors']['text_color']}}" title="Choose your color">
                                </div>
                                <small class="text-danger">@error('heading_color') {{$message}} @enderror </small>
                            </div>
                            <div class="mb-3">
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="form-label label">{{ trans('admin.heading_color') }}</label>
                                    <input type="color" class="form-control  @error('heading_color') is-invalid @enderror form-control-color" name="heading_color" id="exampleColorInput" value="{{$data['colors']['heading_color']}}" title="Choose your color">
                                </div>
                                <small class="text-danger">@error('heading_color') {{$message}} @enderror </small>
                            </div>
                            <div class="mb-3">
                                <div class="form-group">
                                    <label for="exampleInputPassword1" class="form-label label">{{ trans('admin.background_color') }}</label>
                                    <input type="color" class="form-control  @error('background_color') is-invalid @enderror form-control-color" name="background_color" id="exampleColorInput" value="{{$data['colors']['background_color']}}" title="Choose your color">
                                </div>
                                <small class="text-danger"> @error('sub_heading_color') {{$message}} @enderror </small>

                            </div>
                        </div>
                        <div class="col-9">
                            <div class="form-group">
                                <label for="">{{ trans('admin.Copyright') }} </label>
                                <input type="text" name="copy_right" id="" class="form-control @error('copy_right') is-invalid @enderror" value="{!!$data['copy_right']['name'][$default]!!}">
                                <small class="text-danger"> @error('copy_right') {{$message}} @enderror </small>

                            </div>
                            <div class="form-group mt-3">
                                <label for="">{{ trans('admin.privacy_policy_name') }}</label>
                                <input type="text" name="privacy_and_policy_name" id="privacy_and_policy" value="{{$data['privacy_policy']['name'][$default]}}" class="form-control  @error('privacy_and_policy') is-invalid @enderror">
                                <small class="text-danger"> @error('privacy_and_policy_name') {{$message}} @enderror </small>

                                {{-- <label for="">{{ trans('admin.privacy_policy_link') }}</label>
                                <input type="text" name="privacy_and_policy_link" id="privacy_and_policy" value="{{$data['privacy_policy']['link']}}" class="form-control  @error('privacy_and_policy') is-invalid @enderror">

                                <small class="text-danger"> @error('privacy_and_policy_link') {{$message}} @enderror </small> --}}

                            </div>
                            <div class="form-group mt-3">
                                <label for="">{{ trans('admin.terms_conditions_name') }}</label>
                                <input type="text" value= "{{$data['terms_and_condetion']['name'][$default]}}" name="terms_and_condetion_name" id="terms_and_condetion" class="form-control  @error('terms_and_condetion_name') is-invalid @enderror">
                                <small class="text-danger"> @error('terms_and_condetion_name') {{$message}} @enderror </small>

                            </div>
                            {{-- <div class="form-group">
                                <label for="">{{ trans('admin.terms_conditions_link') }}</label>
                                <input type="text" value= "{{$data['terms_and_condetion']['link']}}" name="terms_and_condetion_link" id="terms_and_condetion_link" class="form-control  @error('terms_and_condetion_link') is-invalid @enderror">

                                <small class="text-danger"> @error('terms_and_condetion_link') {{$message}} @enderror </small>

                            </div> --}}
                        </div>

                    </div>

                    <div class="row mt-5">
                        <div class="col-3 text-left">
                            <button type="submit" class="btn btn-warning col-bt rounded-pill text-white">{{ trans('admin.update') }}</button>
                        </div>
                    </div>
                </div>
            </div>
    </form>
</div>
</div>

@endsection
@section('custom-js')
<script src="//cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('sub_heading');

    function preview(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }

    $("#language").change(function(){
        url = "{{'/'.@Request::segment(1).'/'.@Request::segment(2).'/'.@Request::segment(3).'/'}}"+$(this).val();
        window.location.href = url
    })
</script>
@include('admin.frontend.frontendJS')
@endsection
