@extends('admin.layout.master')
@section('content')
<div class="row justify-content-between rounded bg-light p-2 mx-3 m-2">
    <div class="col-12 align-self-centerp p-3">
        <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill theme_text_color"></span>
        <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/frontend')}}">{{trans('admin.front_end')}}</a><span class="bi bi-caret-right theme_text_color"></span><span class='text-decoration-none fw-bold theme_text_color' >{{$section}}</span>
    </div>
</div>
<div class="container-fluid">

    <br>
    <form action="{{url('frontend/update')}}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="section" value="{{$section}}">
        <div class="card p-3 m-2">
            @php
                if(@Request::segment(4) != '' ){
                    $default = @Request::segment(4);

                }
            @endphp
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{session()->get('success')}}
                </div>
            @endif
            <div class="row">
                <div class="col-12">
                    <div class="row mb-2">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            <div class="form-group">
                                <label for="language">{{ trans('admin.select_language') }}</label>

                            </div>
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            <select name="language" id="language" class="form-select bg-light_c rounded-pill @error('language') is-invalid @enderror">
                                <option value="">{{ trans('admin.select') }}</option>
                                @foreach ($language as $item)
                                @php
                                $selected = ($item->abbr == $default) ? "selected" : "";
                                @endphp
                                <option value="{{$item->abbr}}" {{$selected}}>{{$item->name}}</option>
                                @endforeach
                            </select>
                            <small class="text-danger">@error('language') {{$message}} @enderror </small>
                            <hr class="bg-secondary">
                        </div>
                    </div>
                    @php
                        if(!isset($data['title'][$default])){
                            $default = 'en';
                        }
                    @endphp
                    <div class="row">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            {{ trans('admin.colors') }}
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            <div class="row bg-light mx-1 rounded p-2">

                                <div class="col-sm-6 col-md-4 d-none">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1" class="form-label">{{ trans('admin.text_color') }}</label>
                                        <input type="color" class="form-control  @error('text_color') is-invalid @enderror form-control-color" name="text_color" id="exampleColorInput" value="{{$data['colors']['text_color']}}" title="Choose your color">
                                    </div>
                                    <small class="text-danger">@error('text_color') {{$message}} @enderror </small>
                                </div>

                                <div class="col-sm-6 col-md-4 d-none">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1" class="form-label">{{ trans('admin.heading_color') }}</label>
                                        <input type="color" class="form-control  @error('title_color') is-invalid @enderror form-control-color" name="title_color" id="exampleColorInput" value="{{$data['colors']['title_color']}}" title="Choose your color">
                                    </div>
                                    <small class="text-danger">@error('title_color') {{$message}} @enderror </small>
                                </div>

                                <div class="col-sm-12 col-md-4">
                                    <div class="form-group">
                                        <label for="exampleInputPassword1" class="form-label">{{ trans('admin.background_color') }}</label>
                                        <input type="color" class="form-control  @error('background_color') is-invalid @enderror form-control-color" name="background_color" id="exampleColorInput" value="{{$data['colors']['background_color']}}" title="Choose your color">
                                    </div>
                                    <small class="text-danger"> @error('background_color') {{$message}} @enderror </small>
                                </div>
                                <div class="col-sm-12 col-md-4 d-none">
                                    <div class="form-group">
                                        <label for="exampleInputPassword1" class="form-label">{{ trans('admin.description') }}</label>
                                        <input type="color" class="form-control  @error('description_color') is-invalid @enderror form-control-color" name="description_color" id="exampleColorInput" value="{{$data['colors']['description_color']}}" title="Choose your color">
                                    </div>
                                    <small class="text-danger"> @error('description_color') {{$message}} @enderror </small>
                                </div>

                            </div>
                            <hr class="bg-secondary">
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                        {{ trans('admin.title') }}
                        </div>
                        <div class="col-6 col-md-9 offset-md-1 text-md-end fw-bold">
                            <div class="form-group">
                                <textarea id="title" name="title" class="form-control @error('title') is-invalid @enderror">{{$data['title'][$default]}}</textarea>
                                @error('title')
                                    <small class="text-danger">{{$message}}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                            <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            {{ trans('admin.description') }}
                        </div>
                        <div class="col-6 col-md-9 offset-md-1 text-md-end fw-bold">
                            <div class="form-group">
                                <textarea name="description"  class="form-control @error('description') is-invalid @enderror" id="description">{{$data['description'][$default]}}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 text-md-end pt-4 mb-5 text-center">
                            <button type="submit" class="btn btn-warning col-bt rounded-pill text-white">{{ trans('admin.update') }}</button>
                        </div>
                    </div>
                </div>
            </div>
    </form>
</div>
</div>

@endsection
@section('custom-js')
<script src="//cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('title');
    CKEDITOR.replace('description');

    function preview(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }

    $("#language").change(function(){
        url = "{{'/'.@Request::segment(1).'/'.@Request::segment(2).'/'.@Request::segment(3).'/'}}"+$(this).val();
        window.location.href = url
    })
</script>
@include('admin.frontend.frontendJS')
@endsection
