@extends('admin.layout.master')
@section('content')
<script src="//cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>


<div class="container-fluid">
    <div class="row  justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill theme_text_color"></span>
            <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/frontend')}}">{{trans('admin.front_end')}}</a><span class="bi bi-caret-right theme_text_color"></span><span class='text-decoration-none fw-bold theme_text_color' >{{$section}}</span>

        </div>
    </div>

    <div class="card p-3 m-2 mt-3">
        @if ($errors->has('photo.*') || $errors->has('title.*') || $errors->has('content.*') || $errors->has('language.*'))
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->get('photo.*') as $error)
                        @foreach ($error as $er )
                            <li> {{$er}}</li>
                        @endforeach
                        @endforeach
                        @foreach ($errors->get('title.*') as $error)
                            @foreach ($error as $er )
                                <li> {{$er}}</li>
                            @endforeach
                        @endforeach
                        @foreach ($errors->get('content.*') as $error)
                            @foreach ($error as $er )
                                <li> {{$er}}</li>
                            @endforeach
                        @endforeach
                        @foreach ($errors->get('language.*') as $error)
                        @foreach ($error as $er )
                            <li> {{$er}}</li>
                        @endforeach
                    @endforeach
                </ul>
            </div>
        @endif
        @php
            // var_dump(request()->session()->get('success'));
        @endphp
        @if (session()->has('success'))
            <div class="alert alert-success">
                {{session()->get('success')}}
            </div>
        @endif
        <form method="post" action="{{url('frontend/update')}}" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="section" value="{{$section}}">
            @php
                $s = 0;
            @endphp
            @foreach ($data as $index => $value)

                @if (is_array($value))
                    <div class="row">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            <label for="language">{{ trans('admin.select_language') }}</label>
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            <select name="language[{{$s}}]" id="" class="form-select @error('language') is-invalid @enderror">
                                <option value="">{{ trans('admin.select') }}</option>
                                @foreach ($language as $item)
                                    @php
                                        $selected = ($item->abbr == $default) ? "selected" : "";
                                    @endphp
                                    <option value="{{$item->abbr}}" {{$selected}}>{{$item->name}}</option>
                                @endforeach
                            </select>
                            <small class="text-danger">@error('langugage') {{$message}} @enderror </small>
                            <hr class="bg-secondary">
                        </div>
                    </div>
                    <div class="row d-none">
                        <div class="col-4">
                            @isset($value['colors'])
                            <div class="form-group">
                                    <label for="">{{ trans('admin.text_color') }}</label>
                                    <input type="color" class="form-control  @error('text_color') is-invalid @enderror form-control-color" name="text_color[{{$s}}]"  id="exampleColorInput" value="{{$value['colors']['text_color'] }}" title="Choose your color">
                                </div>
                            @endisset
                        </div>
                        <div class="col-4">
                            @isset($value['colors'])
                            <div class="form-group">
                                <label for="">{{ trans('asdmin.title_color') }}</label>
                                <input type="color" class="form-control  @error('title_color') is-invalid @enderror form-control-color" name="title_color[{{$s}}]"  id="exampleColorInput" value="{{$value['colors']['title_color']}}" title="Choose your color">

                            </div>
                            @endisset
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            <label for="language">{{ trans('admin.direction') }}</label>
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            <div class="form-group">
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="direction[{{$s}}]"  {{($value['direction'] == 'rtl') ? "checked" : "" }} id="is_rtl" value="rtl">
                                    <label class="form-check-label" for="inlineRadio1">{{ trans('admin.rtl') }}</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio"  name="direction[{{$s}}]"  {{($value['direction'] == 'ltr') ? "checked" : "" }} id="is_rtl" value="ltr">
                                    <label class="form-check-label" for="inlineRadio2">{{ trans('admin.ltr') }}</label>
                                </div>

                            </div>
                            <hr class="bg-secondary">
                        </div>

                    </div>


                    <div class="row">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            <label for="exampleInputEmail1" class="form-label">{{ trans('admin.title') }}</label>
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            @isset($value['title'])

                                <div class="mb-3">

                                    <textarea type="text" class="form-control @error('title') is-invalid @enderror  rounded-pill bg-light_c" id="title{{$s}}" name= "title[{{$s}}]">{{$value['title'][$default]}}</textarea>
                                    @error('title')
                                        <small class="text-danger">{{$message}}</small>
                                    @enderror
                                </div>
                            @endisset
                            <hr class="bg-secondary">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            <label for="photo">{{ trans('admin.photo') }}</label>
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            <img src="{{asset($value['photo'])}}" alt="" class="img img-thumbnail" width="100px">
                            <input type="file" class="form-control file" name="photo[{{$s}}]" id="file" class="d-none"/>
                            <hr class="bg-secondary">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            <label for="photo">{{ trans('admin.content') }}</label>
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            @isset($value['content'])
                                <textarea class="form-control bg-light_c @error('content') is-invalid @enderror  rounded cat" id="content_{{$s}}" name="content[]" rows="4">{!!$value['content'][$default]!!}</textarea>
                                @error('content')
                                    <small class="text-danger">{{$message}}</small>
                                @enderror
                            @endisset
                            <hr class="bg-secondary">
                        </div>
                    </div>

                    <script>
                        CKEDITOR.replace( '{{"content_".$s}}' );
                        CKEDITOR.replace( '{{"title".$s}}' );
                    </script>
                @endif
                @php $s++; @endphp
            @endforeach
            <div class="row">
                <div class="col-12 text-md-end text-center">
                    <button type="submit" class="btn btn-warning col-bt rounded-pill text-white">{{ trans('admin.update') }}</button>
                </div>
            </div>

        </form>
    </div>
</div>
<style>
    .form-control,
    .cat {
        font-size: 14px;
        color: #383838;
    }

</style>

<script>

    // document ready
    $(document).ready(function () {
        $(".file").change(function (event) {
            $(this).prev('img').attr('src', URL.createObjectURL(event.target.files[0]));
        });
    });
</script>
@endsection
