@extends('admin.layout.master')
@section('content')
<div class="row justify-content-between rounded bg-light p-2 m-2">
    <div class="col-12 align-self-center">
        <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill theme_text_color"></span>
            <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/frontend')}}">{{trans('admin.front_end')}}</a><span class="bi bi-caret-right theme_text_color"></span><span class='text-decoration-none fw-bold theme_text_color' >{{$section}}</span>
    </div>
</div>
<div class="container-full">
    <form action="{{url('frontend/update')}}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="section" value="{{$section}}">
        <div class="card p-3 m-2">
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{session()->get('success')}}
                </div>
            @endif
           <div class="row">
                <div class="col-6">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-label label">{{ trans('admin.btn_background') }}</label>
                        <input type="color" class="form-control  @error('button_background') is-invalid @enderror form-control-color" name="button_background" id="exampleColorInput" value="{{$data['colors']['button_background']}}" title="Choose your color">
                    </div>
                    <small class="text-danger">@error('button_background') {{$message}} @enderror </small>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-label label">{{ trans('admin.btn_foreground') }}</label>
                        <input type="color" class="form-control  @error('button_foreground') is-invalid @enderror form-control-color" name="button_foreground" id="exampleColorInput" value="{{$data['colors']['button_foreground']}}" title="Choose your color">
                    </div>
                    <small class="text-danger">@error('button_foreground') {{$message}} @enderror </small>
                </div>
           </div>
            <div class="row">
                <div class="col-6">
                        <div class="form-group">
                            <label for="exampleInputPassword1" class="form-label label">{{ trans('admin.input_background') }}</label>
                            <input type="color" class="form-control  @error('inputs_background') is-invalid @enderror form-control-color" name="inputs_background" id="exampleColorInput" value="{{$data['colors']['inputs_background']}}" title="Choose your color">
                        </div>
                        <small class="text-danger"> @error('inputs_background') {{$message}} @enderror </small>

                </div>
                <div class ="col-6">
                        <div class="form-group">
                            <label for="exampleInputPassword1" class="form-label label">{{ trans('admin.input_foreground') }}</label>
                            <input type="color" class="form-control  @error('inputs_background') is-invalid @enderror form-control-color" name="inputs_background" id="exampleColorInput" value="{{$data['colors']['inputs_background']}}" title="Choose your color">
                        </div>
                        <small class="text-danger"> @error('inputs_background') {{$message}} @enderror </small>

                </div>
            </div>

        <div class="row">
            <div class="col-3 mt-3 text-md-left">
                <button type="submit" class="btn btn-warning col-bt rounded-pill text-white">{{ trans('admin.update') }}</button>
            </div>
        </div>
    </form>
</div>
</div>

@endsection
@section('custom-js')
<script src="//cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('sub_heading');
</script>
<script>
    function preview(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@include('admin.frontend.frontendJS')
@endsection
