@extends('admin.layout.master')
@section('content')
<div class="row justify-content-between rounded bg-light p-2 m-2">
    <div class="col-12 align-self-center">
        <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill theme_text_color"></span>
        <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/frontend')}}">{{trans('admin.front_end')}}</a><span class="bi bi-caret-right theme_text_color"></span><span class='text-decoration-none fw-bold theme_text_color' >{{$section}}</span>

    </div>
</div>
<div class="container-full">

    <form action="{{url('frontend/update')}}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="section" value="{{$section}}">
        <div class="card p-3 m-2">
            @php
                if(@Request::segment(4) != '' ){
                    $default = @Request::segment(4);

                }
            @endphp

            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{session()->get('success')}}
                </div>

            @endif
            <div class="row">
                <div class="col-sm-12">
                    <div class="row mb-2">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            <label for="language">{{ trans('admin.select_language') }}</label>
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">

                            <select name="language" id="language" class="form-select bg-light_c rounded-pill @error('language') is-invalid @enderror">
                                <option value="">{{ trans('admin.select') }}</option>
                                @foreach ($language as $item)
                                @php
                                $selected = ($item->abbr == $default) ? "selected" : "";
                                @endphp
                                <option value="{{$item->abbr}}" {{$selected}}>{{$item->name}}</option>
                                @endforeach
                            </select>
                            <small class="text-danger">@error('language') {{$message}} @enderror </small>
                            <hr class="bg-secondary">
                        </div>
                    </div>
                    @php
                        if(!isset($data['heading'][$default])){
                            $default = 'en';
                        }
                    @endphp
                    <div class="row py-3 d-none">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            {{ trans('admin.colors') }}
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            <div class="row bg-light mx-1 rounded p-2">
                                <div class="col-6">
                                    <label for="exampleInputEmail1" class="form-label">{{ trans('admin.heading_color') }}</label>
                                    <input type="color" class="form-control  @error('heading_color') is-invalid @enderror form-control-color" name="heading_color"  id="exampleColorInput" value="{{$data['colors']['heading_color']}}" title="Choose your color">
                                    <small class="text-danger">@error('heading_color') {{$message}} @enderror </small>
                                </div>
                                <div class="col-6">
                                    <label for="exampleInputPassword1" class="form-label label">{{ trans('admin.sub_heading_color') }}</label>
                                    <input type="color" class="form-control  @error('sub_heading_color') is-invalid @enderror form-control-color"  name="sub_heading_color" id="exampleColorInput" value="{{$data['colors']['sub_heading_color']}}" title="Choose your color">
                                    <small class="text-danger"> @error('sub_heading_color') {{$message}} @enderror </small>
                                </div>
                            </div>
                            <hr class="bg-secondary">
                        </div>
                    </div>
                    <div class="row py-3">
                        <div class="col-sm-6 col-md-2 text-md-end fw-bold">
                            {{ trans('admin.photo') }}
                        </div>
                        <div class="col-sm-6 col-md-9 offset-md-1">
                            <label class="upload-btn-wrapper bg-light_c" for="file"> <span class="text_img">{{ trans('admin.photo') }}</span>
                                <img src="{{asset($data['photo'])}}" class="img-fluid" alt="" id="preview">
                            </label>
                            <input type="file" name="photo" id="file" class="d-none" onchange="previewa(event)" />
                            <small class="text-danger"> @error('photo') {{$message}} @enderror </small>
                            <hr class="bg-secondary">
                        </div>
                    </div>
                    <div class="row py-3">
                        <div class="col-sm-12 col-md-2 text-md-end fw-bold">
                            {{ trans('admin.content') }}
                        </div>
                        <div class="col-sm-12 col-md-9 offset-md-1">
                            <div class="form-group mb-3">
                                <label for="">{{ trans('admin.heading') }}</label>
                                {{-- <input type="text" name="heading"  class="form-control bg-light_c rounded-pill @error('heading') is-invalid @enderror" value="{!!$data['heading'][$default]!!}"> --}}
                                <textarea name="heading" id="heading" class="form-control bg-light_c rounded-pill @error('heading') is-invalid @enderror">{!!$data['heading'][$default]!!}</textarea>
                                <small class="text-danger"> @error('heading') {{$message}} @enderror </small>

                            </div>
                            <div class="form-group">
                                <label for="">{{ trans('admin.sub_heading') }}</label>
                                <textarea name="sub_heading" id="sub_heading" class="form-control bg-light_c rounded-pill @error('sub_heading') is-invalid @enderror">{!!$data['sub_heading'][$default]!!}</textarea>
                                <small class="text-danger"> @error('sub_heading') {{$message}} @enderror </small>

                            </div>
                            <hr class="bg-secondary">
                        </div>

                    </div>

                </div>
                <div class="row">
                    <div class="col-12 text-md-end text-center">
                        <button type="submit" class="btn btn-warning col-bt rounded-pill text-white">{{ trans('admin.update') }}</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
</div>

@endsection
@section('custom-js')
<script src="//cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace( 'sub_heading' );
    CKEDITOR.replace( 'heading' );
</script>
<script>

    function previewa(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }

    $("#language").change(function(){
        url = "{{'/'.@Request::segment(1).'/'.@Request::segment(2).'/'.@Request::segment(3).'/'}}"+$(this).val();
        window.location.href = url
    })

</script>
@include('admin.frontend.frontendJS')
@endsection
