@extends('admin.layout.master')
@section('content')
<div class="row justify-content-between rounded bg-light shado-sm p-2 my-2 mx-3">
  <div class="col-12 align-self-center p-1 px-2">
      <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right"></span>
      <span class='text-decoration-none fw-bold' >{{trans('admin.countries')}}</span>  
  </div>
</div> 
<main class="container-fluid px-0 scroll-y">
    <!-- body content  -->
    <div class="card card-invoice rounded border-0">
      <div class="card-body pt-0">
        <div class="row g-2 p-0 align-items-end bg-light px-2 pb-2 border mt-1 mx-0 no-print" id="from_to_date_area">
          <div class="col-md-2 col-6 mt-1">
            <input type="text" class="filtertbl form-control form-control-sm rounded-pill" id="search_new" style="min-width:150px;" placeholder="{{trans('admin.search')}}">
          </div>
          <div class="col-auto ms-md-auto">
            <button class="btn btn-success rounded-pill btn-sm px-3" onclick="add_category()">
              {{trans('admin.add_New')}}
            </button>
          </div>
      </div>

        <div class="row my-2">
          <div class="col-lg-12">
            <div class="table-responsive">
              <table class="table w-100 table-sm table-hover mb-0 table-bordered data-table">
                <thead class="bg-light">
                    <tr>
                        <th>{{trans('admin.id')}}</th>
                        <th>{{trans('admin.name')}}</th>
                        {{-- <th>{{trans('admin.Name')}}</th> --}}
                        <th>{{trans('admin.status')}}</th>
                        <th>{{trans('admin.action')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
        </div>
      </div>
    </div>
  </div>
</main>
<style>
    .dataTables_filter {
    display: none;
  }
</style>
<script type="text/javascript">
  var table ="";
  $(function () {
    table = $('.data-table').DataTable({
      processing: true,
      serverSide: true,
      ajax: "{{ url('countries') }}",
      columns: [
          {data: 'id', name: 'id'},
          {data: 'name_en', name: 'name_en'},
        //   {data: 'name_ar', name: 'name_ar'},
          {data: 'status', name: 'status'},
          {data: 'action', name: 'action', orderable: false, searchable: false},
      ],
      "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
    });
  });
  $("#search_new").on("keyup search input paste cut", function() {
     table.search(this.value).draw();
  });
</script>

{!! modelBox("addcategory", trans('admin.add'),"box","status_msg","add_category") !!}
{!! modelBox("editcategory", trans('admin.edit'),"box_edit","status_update","update_category") !!}
@endsection
@section('custom-js')
@include('admin.countries.country_js')
@endsection
