@extends('admin.layout.master')
@section('content')
<style>
    option {
        font-size: 12px !important;
    }
</style>
<div class="container">
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  text-dark breadc' href="">
                ContactUs View
            </a>
        </div>
    </div>
</div>
<section>
    <div class="container">
        <div class="row p-2">
        	<div class="col-12">
	            @if(session()->has('success'))
	                <div class="bg-success p-2 mt-4 rounded text-white">
	                    <span class="input-error">{{ session()->get('success') }}</span>
	                </div>
	            @elseif(session()->has('error'))
	                <div class="bg-danger p-2 mt-4 rounded text-white">
	                    <span class="input-error">{{ session()->get('error') }}</span>
	                </div>
	            @endif
	        </div>

            <div class="col-md-7 bg-light_c p-3 rounded g-2">
	        	<label class="label label" for="text">Contact Us Message</label>
	            <div class="container">
	                <p class='fw-bold text-dark mt-2'>
	                	{{$post->text}} <small></small>
	                </p>
	            </div>
	        </div>
            <!-- END 7 COL  -->
	        <div class="col-md-5">
	        	<div class="container">
	                <form action="{{route('contact_reply')}}" method="post">
		            	<input type="hidden" name="_token" value="{{ csrf_token() }}" />
		                <input type="hidden" name="id" id="id" value="{{$post->id}}">
		                <input type="hidden" name="email" id="email" value="{{$post->email}}">
		                <input type="hidden" name="name" id="name" value="{{$post->name}}">
		                <div class="mb-3">
                            <label for="hosts" class="form-label label">Hosts</label>
                            <select  id="hosts" class="form-select rounded-pill bg-light cat" name="hosts">
                                <option value="">Select</option>
                                @foreach(email_host_list() as $host)
                                <option value="{{$host->id}}" @if($host->is_default == 1) selected @endif>{{$host->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="subject" class="form-label label">Subject</label>
                            <input type="text" class="form-control rounded-pill bg-light_c @error('subject') is-invalid @enderror" name="subject" id="subject" value="{{ old('subject') }}">
                            @error('subject') 
		                        <span class="text-danger">{{ $message }}</span> 
		                    @enderror
                        </div>
		                <div class="mb-3 position-relative">
		                	<label class="label" for="text">Support Reply</label>
		                    <textarea id="editor" name="message" class="form-control bg-light_c border-0 rounded cat @error('message') is-invalid @enderror" rows="15" placeholder="Type here"></textarea>
		                    @error('message') 
		                        <span class="text-danger">{{ $message }}</span> 
		                    @enderror
		                </div>
		                <div class='d-flixs'>
		                    <button type="submit" class="btn btn-warning col-bt rounded-pill mb-4 mt-2 text-white">Reply</button>
		                </div>
		            </form>
	            </div>
	        </div>
            <!-- END 12 COL  -->            
        </div>
    </div>
</section>
<script type="text/javascript">
      CKEDITOR.replace('editor');
   </script>
@endsection