@extends('admin.layout.master')
@section('content')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{ trans('admin.Home') }}</a> <span class="bi bi-caret-right"></span>
            <a class='text-decoration-none fw-bold text-dark' href=""> {{ trans('admin.contact_us') }}</a>
        </div>
        <div class="col-12 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row">
                    <div class="col-7">
                        <div>
                            <input type="text" class="form-control rounded-pill bg-light" id="search_new" placeholder="{{trans('admin.search')}}">
                        </div>
                    </div>
                    <div class="col-5">
                        <select id="status_filter" class="form-select rounded-pill">
                          <option value="" selected> {{ trans('admin.All') }}</option>
                          <option value="1"> {{ trans('admin.Viewed') }}</option>
                          <option value="0"> {{ trans('admin.Not_viewed') }} </option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class='table-responsive p-3'>
        <table class='table table-border data-table w-100'>
            <thead>
                <tr class='tex-g'>
                    <th>{{ trans('admin.name') }}</th>
                    <th>{{ trans('admin.email') }}</th>
                    <th>{{ trans('admin.date') }}</th>
                    <th>{{ trans('admin.is_viewed') }}</th>
                    <th>{{ trans('admin.reply_count') }}</th>
                    <th>{{ trans('admin.actions') }}</th>
                </tr>
            </thead>
            <tbody>
                 
            </tbody>
        </table>
    </div>
</div>
<script type="text/javascript">
    var table = "";
    $(function() {
        table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            "searching": false,
            ajax: {
                url: "{{ route('contact_us_list') }}",
                type: 'GET',
                data: function(d) {
                  d.search_new = $('#search_new').val();
                  d.status_filter = $('#status_filter').val();
                  // console.log(d);
                }
            },
            columns: [
                {data: 'name', name: 'name'},
                {data: 'email', name: 'email'},
                {data: 'created_at', name: 'created_at'},
                {data: 'is_viewed', name: 'is_viewed', orderable: false},
                {data: 'reply_count', name: 'reply_count', orderable: false},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ],
            "lengthMenu": [[10, 25, 50, 100, -1], [100, 200, 500, 700, "All"]]
        });
    });
    $('body').on('change', '#status_filter', function(e) {
      table.draw(true);
    });
    $('body').on('keyup', '#search_new', function(e) {
      table.draw(true);
    });
    $('body').on('click', '.clear', function(e) {
        $('#search_new').val("");
        $('#status_filter').val("");
        table.draw(true);
    });
</script>
@endsection
