var state = false;
var oldReportMenu = null;
var oldValue = 0;

loading();

$(document).ready(function () {
    loading("stop");
    // report menu in sidebar
    $("nav a.dropdown-toggle").click(function(event) {
      if (oldValue != 0 && $(this).attr('data-value') != oldValue) {
        $(oldReportMenu).next('ul').removeClass('show');
        $(oldReportMenu).attr('aria-expanded', 'false');

      }

      oldReportMenu = $(this);
      oldValue = $(this).attr('data-value');
      
    });

    // For sidebar
    $('#sidebarCollapse').on('click', function () {
        $('#sidebar').toggleClass('barhide');
        $('#content').toggleClass('barhide');
        $('.fixed-content').toggleClass('barhide');
        state = false;
    });

    if ($(window).width() <= 992) { 
      $('#sidebarCollapse').click();

    }

    $(window).resize(function(){
        if ($(window).width() <= 1249 && !$('#sidebar').hasClass('barhide')) { 
          $('#sidebarCollapse').click();
          state = true;

        } else {
          if (state == true) {
            if ($(window).width() >= 1250 && $('#sidebar').hasClass('barhide')) {

            $('#sidebarCollapse').click();
              state = true;

            }
          }
        }
    });
    
    $("#notification-btn, #notification .close-details").click(function(e){
      $("#notification").toggle();
      $("#grid-menu, #setting-menu, #user-prof").hide();
    });

    $("#user-prof-btn, #user-prof .close-details").click(function(e){
      $("#user-prof").toggle();
      $("#grid-menu, #setting-menu, #notification").hide();
    });


    $("#grid-menu-btn, #grid-menu .close-details").click(function(e){
      $("#grid-menu").toggle();
      $("#user-prof, #setting-menu, #notification").hide();
    });
    
    $("#setting-menu-btn, #setting-menu .close-details").click(function(e){
      $("#setting-menu").toggle();
      $("#grid-menu, #user-prof, #notification").hide();
    });
    
    // For select2 
    // $(".select2").select2();
    // $(".select2-multiple").select2({
    //   placeholder: 'Select one or more',
    // });

    // tabel sort
    tablesort("sort");

    // submenu propigation
    $(".dropdown-submenu a").click(function(e){
        e.stopPropagation();
    });

    // Notification counter
    var notification_counter = $(".count-notification").length;
    
    if (notification_counter > 0) {
        $(".blink-notify").html(notification_counter);
        $(".blink-notify").show();
    }

});
// Exporting PDF and Excel //////////////////////////////////////////////////////////////////////////////
function exportTable(table, fileType, name){
    $('.'+table).tableHTMLExport({type: fileType, filename: name+'.'+fileType});
}


// table sorting ////////////////////////////////////////////////////////////////////////////////////////
function tablesort(tableid){
    if ($("."+tableid).length) {

        // search filter
        $(".filtertbl").on('keyup',function() {
            var value = $(this).val().toLowerCase();
            $("."+tableid+" tbody tr").filter(function() {
              $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
        
        if ($("#sort-columns").html().length > 0) {
                return false;
        }else{
            $("."+tableid+" thead th").each(function(index){
                $("#sort-columns").append("\
                    <li><a class='dropdown-item' href='#' data-index='"+$(this).index()+"'>\
                        <svg width='18' height='18' viewBox='0 0 16 16' class='bi bi-check' fill='currentColor' xmlns='http://www.w3.org/2000/svg'>\
                            <path fill-rule='evenodd' d='M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z'></path>\
                        </svg>  "+$(this).text()+"\
                    </a></li>\
                ");
                
            });
        }
        
        
        $("#sort-columns li a").click(function(e){
            e.stopPropagation();
            var i = $(this).attr('data-index');
            i++;
            $('.'+tableid+' tbody td:nth-child('+i+')').toggle();
            $('.'+tableid+' thead th:nth-child('+i+')').toggle();
            
            $(this).children('svg').toggle();

        });
        
        $('.'+tableid).tablesorter();
    
    }
}


function loading(action){

    if (action == "stop") {
        $(".loading").css('display', 'none');;
        document.body.style.cursor='pointer';

    }else{
        $(".loading").css('display', 'flex');;
        document.body.style.cursor='wait';

    }

};


// convert to float and round decimal values
function decimal(value){
    // console.log(value);
    decimal_value = $("#decimal_value").val();
    value = parseFloat(value);
    if (String(value).split(".").length < decimal_value || String(value).split(".")[1].length <= decimal_value ){
        return parseFloat(value.toFixed(decimal_value));

    }else{
        return parseFloat(value.toFixed(decimal_value));
    }
}

function change_language(lang){
    try {
        $.ajax({
            url: "ajax/change_language.php",
            data: {lang: lang },
            type: "POST",
            cache: false,
            success: function (frm) {
                $(".msg").html(frm);

            },
            error: function (xhr) {
                console.log("Error: "+xhr.status+" "+xhr.statusText);

            }
        });
    } catch (e) {
        alert(e.message);
    }
}

function change_theme(theme){
    try {
        $.ajax({
            url: "ajax/change_theme.php",
            data: {theme: theme },
            type: "POST",
            cache: false,
            success: function (frm) {
                $(".msg").html(frm);

            },
            error: function (xhr) {
                console.log("Error: "+xhr.status+" "+xhr.statusText);

            },
        });
    } catch (e) {
        alert(e.message);
    }
}

// for opening and closing bootstrap 5 modal
function modal(id, state = "open"){
    if (state == "open") {
        var myModal = new bootstrap.Modal(document.getElementById(id));
        myModal.toggle();

    }else{
        var myModal = document.getElementById(id);
        bootstrap.Modal.getInstance(myModal).hide();

    }
}

function permission_msg(txt){ swal(txt); }

function swal(msg, type){

   bg = "bg-danger";

    if (type == 'success' ) {
        bg = "bg-success";

    }else if (type == "info") {
        bg = "bg-info";

    }

    var toast = '\
       <div id="toast" class="toast d-flex align-items-center text-white border-0 '+bg+'" role="alert" aria-live="assertive" aria-atomic="true" style="min-width:300px; z-index: 9999999999 !important; position: fixed; right: 20px; top: 20px;">\
         <div class="toast-body">\
           '+msg+'\
         </div>\
         <button type="button" class="btn-close btn-close-white mr-2 mt-2 position-absolute top-0 right-0"" data-dismiss="toast" aria-label="Close"></button>\
       </div>\
    ';

    $(".toast_div").html(toast);
    var toastElList = [].slice.call(document.querySelectorAll(".toast"));
    var toastList = toastElList.map(function(toastEl) {
  
        return new bootstrap.Toast(toastEl,{
            animation: true,
            autohide: true,
            delay: 5000
        }); // No need for options; use the default options

    });

    toastList.forEach(toast => toast.show()); // This show them

    var myToastEl = document.getElementById('toast');
    myToastEl.addEventListener('hidden.bs.toast', function () {
        $("#toast").remove();
    })

}



// $("document").ready(function () {
//   $("#cus_id_val").select2();
//   $("#cus_id_val").select2("open");
// });