<?php

namespace Database\Seeders;

use App\Models\Menu;
use Illuminate\Database\Seeder;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            [
                'id' => 1,
                'menu_name' => 'Dashboard',
                'menu_ar' => '',
                'route' => '/home',
                'type' => '2',
                'status' => '1',
                'parent_id' => 0,
            ],
            [
                'id' => 2,
                'menu_name' => 'Manage',
                'menu_ar' => '',
                'route' => '/manage',
                'type' => '2',
                'status' => '1',
                'parent_id' => 0,
            ],
            [
                'id' => 3,
                'menu_name' => 'Pages',
                'menu_ar' => '',
                'route' => '/pages',
                'type' => '2',
                'status' => '1',
                'parent_id' => 2,
            ],
            [
                'id' => 4,
                'menu_name' => 'Countries',
                'menu_ar' => '',
                'route' => '/countries',
                'type' => '2',
                'status' => '1',
                'parent_id' => 2,
            ],
            [
                'id' => 5,
                'menu_name' => 'Social Media',
                'menu_ar' => '',
                'route' => '/socials',
                'type' => '2',
                'status' => '1',
                'parent_id' => 2,
            ],
            [
                'id' => 6,
                'menu_name' => 'Quick Links',
                'menu_ar' => '',
                'route' => '/manage',
                'type' => '2',
                'status' => '1',
                'parent_id' => 0,
            ],
            [
                'id' => 7,
                'menu_name' => 'Send Emails',
                'menu_ar' => '',
                'route' => '/email_templates',
                'type' => '2',
                'status' => '1',
                'parent_id' => 6,
            ],
            [
                'id' => 8,
                'menu_name' => 'Email Templates',
                'menu_ar' => '',
                'route' => '/email_templates',
                'type' => '2',
                'status' => '1',
                'parent_id' => 6,
            ],
            [
                'id' => 9,
                'menu_name' => 'Configuration',
                'menu_ar' => '',
                'route' => '/site_info',
                'type' => '1',
                'status' => '1',
                'parent_id' => 0,
            ],
            [
                'id' => 10,
                'menu_name' => 'Manage Users',
                'menu_ar' => '',
                'route' => '/users',
                'type' => '1',
                'status' => '1',
                'parent_id' => 0,
            ],
            [
                'id' => 11,
                'menu_name' => 'User Role',
                'menu_ar' => '',
                'route' => '/user_roles',
                'type' => '1',
                'status' => '1',
                'parent_id' => 0,
            ],
            [
                'id' => 12,
                'menu_name' => 'Menu(s)',
                'menu_ar' => '',
                'route' => '/menu',
                'type' => '1',
                'status' => '1',
                'parent_id' => 0,
            ],
        ];

        Menu::insert($data);
    }
}
