<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToInvoicemainTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoice_main', function (Blueprint $table) {
            $table->tinyInteger('payment_type')->default(0)->comment('1= cash, 2=bank, 2=credit cart');
            $table->string('attachments')->nullable();
            $table->tinyInteger('is_approve')->default(0)->comment('0=not approve, 1=approve');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoice_main', function (Blueprint $table) {
            //
        });
    }
}
