<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->string('code')->nullable();
            $table->string('value')->comment('fixed or percentage i-e 5 SR or 5%')->nullable();
            $table->enum('is_first_order',[0,1])->default(0)->comment('0=false, 1=true');
            $table->date('expirey_date')->nullable();
            $table->integer('limit')->nullable()->comment('limit is a counter for how much time it will be used');
            $table->double('amount_limit')->nullable()->comment('minimum order amount limit');
            $table->double('max_discount')->nullable();
            $table->enum('status',[0,1])->default(1)->comment('0=active,1=inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
    }
}
