<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RevokVendorTypes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vendor_types', function (Blueprint $table) {
            $table->dropColumn('name');
            $table->dropColumn('description');
            $table->after('id',function($table){
                $table->string('name_en')->nullable();
                $table->string('name_ar')->nullable();
                $table->text('description_en')->nullable();
                $table->text('description_ar')->nullable();
            });
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vendor_types', function (Blueprint $table) {
            //
        });
    }
}
