<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFromToDateFieldToVendorTiming extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vendor_timings', function (Blueprint $table) {
                $table->after('time', function ($table) {
                    $table->time('to_time')->nullable();
                    $table->integer('day')->nullable();
                });
                $table->renameColumn('time','from_time');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vendor_timings', function (Blueprint $table) {
            $table->dropColumn(['to_time','day']);
        });
    }
}
