<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMobileLandlineCategoryIdsToVendorDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vendor_details', function (Blueprint $table) {
            $table->after('coordinates',function($table){
                $table->string('mobile')->nullable();
                $table->string('landline')->nullable();
                $table->json('category_id')->nullable();

            });
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vendor_details', function (Blueprint $table) {
            $table->dropColumn('mobile');
            $table->dropColumn('landline');
            $table->dropColumn('category_id');

        });
    }
}
