<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('items', function (Blueprint $table) {
            $table->id();
            $table->string('item_name_en');
            $table->string('item_name_ar');
            $table->string('photo');
            $table->double('price');
            $table->string('time');
            $table->string('item_description_en');
            $table->string('item_description_ar');
            $table->integer('vendor_id');
            $table->integer('vendor_cat_id');
            $table->integer('status')->default(0)->comment('0=inactive, 1=active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('items');
    }
}
