<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLanguagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('languages', function (Blueprint $table) {
            $table->id();
            $table->string('abbr');
            $table->string('name');
            $table->string('flag')->nullable();
            $table->string('date_format')->nullable();
            $table->string('datetime_format')->nullable();
            $table->enum('direction', ['ltr', 'rtl'])->default('ltr');
            $table->enum('status',[0,1])->default(1)->comment("1=active, 0=inactive");
            $table->enum('is_default',[0,1])->default(1)->comment("1=default, 0=not default");
            $table->timestamp('deleted_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('languages');
    }
}
