<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmailHostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_hosts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('is_default',[0,1])->default(true)->comment("1=active, 0=inactive");
            $table->string('username');
            $table->string('secret');
            $table->integer('port');
            $table->string('security');
            $table->string('from_name');
            $table->string('from_email');
            $table->enum('status',[0,1])->default(true)->comment("1=active, 0=inactive");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('email_hosts');
    }
}
