<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UsersColumn extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('business_name')->nullable();
            $table->date('dob')->nullable();
            $table->string('gender')->nullable();
            $table->string('address')->nullable(); // 
            $table->string('coordinates')->nullable(); 
            $table->integer('vendor_type_id')->default(0); 
            $table->boolean('room_status')->default(1); // 
            $table->boolean('table_status')->default(1); //  
            $table->boolean('featured')->default(0); //  
            $table->integer('open_status')->default(0); //  
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
             
        });
    }
}
