<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSiteInfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_info', function (Blueprint $table) {
            $table->id();
            $table->string('site_title')->nullable();
            $table->string('site_slogan_en')->nullable();
            $table->string('site_slogan_ar')->nullable();
            $table->string('site_header_logo')->nullable();
            $table->string('site_footer_logo')->nullable();
            $table->string('site_email')->nullable();
            $table->string('site_address_en')->nullable();
            $table->string('site_contact')->nullable();
            $table->string('site_description_en')->nullable();
            $table->string('site_descrition_ar')->nullable();
            $table->string('site_location')->default(0)->comment('latitude lagitude');
            $table->enum('status',[0,1])->default(1)->comment('0=active.1=inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_info');
    }
}
