<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('menus', function (Blueprint $table) {
            $table->id();

            $table->string('menu_name')->nullable();
            $table->string('menu_ar')->nullable();
            $table->text('route')->nullable();
            $table->enum('type',[1,2,3,4])->comment('1=main, 2=side,3=footer, 4=settings')->nullable();
            $table->enum('status', [0,1])->default(1)->comment('0=inactive,1=active')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menus');
    }
}
