<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddEmailHosts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('email_hosts', function (Blueprint $table) {
            $table->string("host_address")->comment('smpt.example.com');
            $table->string("cc")->comment('Carbon Copy Email');
            $table->string("bcc")->comment('Black Carbon Copy Email');
            $table->integer("cc_status")->default(false)->comment('0=inactive, 1=active');
            $table->integer("bcc_status")->default(false)->comment('0=inactive, 1=active');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_hosts', function (Blueprint $table) {
            //
        });
    }
}
