<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupportChatsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('support_chats', function (Blueprint $table) {
            $table->id();
            $table->text('message')->nullable();
            $table->bigInteger('support_id')->nullable();
            $table->bigInteger('user_id')->nullable();
            $table->enum('type',[1,2])->comment('1 = admin side, 2= user side')->nullable();
            $table->enum('status',[0,1])->comment('1 = active, 0= inactive')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('support_chats');
    }
}
