<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class StatusToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('ios_device_id')->nullable();
            $table->string('android_device_id')->nullable();
            $table->string('web_device_id')->nullable();
            $table->integer("user_type")->default(1)->comments('1=customer, 2=vendor');
            $table->integer("status")->default(1)->comments('0=inactive, 1=active, 2=applied but not approved');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
}
