<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePromotionSlidersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('promotion_sliders', function (Blueprint $table) {
            $table->id();
            $table->string('photo');
            $table->integer('item_id')->default(0);
            $table->enum('type',[0,1])->default(1)->comment('1=restuarent, 2=item');
            $table->enum('status',[0,1])->default(1)->comment('1=active, 0=inactive');
            $table->date('expiry_date');
            $table->integer('vendor_id')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('promotion_sliders');
    }
}
