<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->string('description_en');
            $table->string('description_ar');
            $table->double('amount');
            $table->double('tax_amount');
            $table->integer('user_id');
            $table->enum('transaction_type',[0,1])->default(1)->comment('1=credit, 2=debit');
            $table->integer('status')->default(1)->comment('1=pending, 2=completed');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
