<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorItemCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendor_item_categories', function (Blueprint $table) {
            $table->id();
            $table->string('photo');
            $table->string('name_en');
            $table->string('name_ar');
            $table->integer('vendor_id');
            $table->boolean('status')->default(true)->comment('true=active, false=inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendor_item_categories');
    }
}
