<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendor_details', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('vendor_type_id');
            $table->boolean('rooms_status')->default(true)->comment('true=active, false=inactive');
            $table->boolean('tables_status')->default(true)->comment('true=active, false=inactive');
            $table->boolean('featured')->default(false)->comment('true=featured, false=normal');
            $table->integer('open_status')->default(0)->comment('0=normal, 1=bussy,2=closed');
            $table->string('business_name');
            $table->string('address');
            $table->string('coordinates');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendor_details');
    }
}
