<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable();
            $table->integer('vendor_id')->nullable();
            $table->double('sub_total')->nullable()->default(0);
            $table->string('tax_value')->nullable();
            $table->double('tax_amount')->nullable()->default(0);
            $table->string('coupon_code')->nullable();
            $table->double('coupon_value')->nullable();
            $table->double('net_total')->nullable();
            $table->double('paid')->nullable();
            $table->integer('payment_method')->comment('1=cash, 2=card, 3=wallet')->nullable();
            $table->boolean('gift_status')->default(0)->comment('true=gift, false=normal');
            $table->integer('gift_user_id')->default(0);
            $table->integer('room_id')->default(0);
            $table->integer('table_id')->default(0);
            $table->integer('time_id')->default(0);
            $table->date('order_date')->nullable();
            $table->integer('status')->default(1)->comment('0=cancel, 1=active, 2=complete, 3=pending for gift');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
