<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePortfolioGallleryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('portfolio_gallery', function (Blueprint $table) {
            $table->id();
            $table->string('photo')->nullable();
            $table->enum('is_main',[0,1])->default(0)->comment('0=normal ,1 =main photo');
            $table->enum('status',[0,1])->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('portfolio_gallery');
    }
}
