<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePortfolioTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('portfolio', function (Blueprint $table) {
            $table->id();
            $table->string('name_en')->nullable();
            $table->string('name_ar')->nullable();
            $table->string('client_name')->nullable();
            $table->string('website_url')->nullable();
            $table->string('description_en')->nullable();
            $table->string('description_ar')->nullable();
            $table->bigInteger('portfolio_type_id')->nullable();
            $table->dateTime('completed_at')->nullable();
            $table->enum('live_status', [0,1,2])->default(0)->comment('0=not live, 1= in development,2=completed');
            $table->enum('active_status',[0,1])->default(1)->comment('0=inactive,2=inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('portfolio');
    }
}
