<?php
function modelBox(string $modal_id = null, string $boxTitle = null, $boxid, string $status_msg = null, string $form_name = null, $m_id = 'abc')
{
    try {

        $drawBox = '
        <div class="modal fade" id="' . $modal_id . '" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
           <div class="modal-dialog modal-lg" role="document" id="' . $m_id . '">
               <div class="modal-content">
                   <div class="modal-header">
                       <h5 class="modal-title">' . $boxTitle . '</h5>
                        <button type="button" onclick="window.location.reload();" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                   </div>
                   <div class="modal-body">
                       <form id="' . $form_name . '">
                        <div  id="' . $boxid . '">

                        </div>
                   </div>
                   <div class="modal-footer position-sticky bottom-0 bg-light">
                      <span id="' . $status_msg . '" class="float-left"></span>
                      <button type="submit" class="btn btn-warning"><i class="fa fa-check-circle"></i>'.trans('admin.Save_Changes').' <i id="spiner-'.$form_name.'" class=""></i></button>
                      <button type="button" onclick="window.location.reload();" class="btn btn-secondary" data-dismiss="modal"> '.trans('admin.Close').'</button>
                   </div>
               </div>
               </form>
           </div>
        </div>';
        return $drawBox;
    } catch (Exception $exc) {
        // $this->tempVar = $exc->getMessage();
        return false;
    }
}
/* Large Modal
*/
function modelBoxLarge(string $modal_id = null, string $boxTitle = null, $boxid, string $status_msg = null, string $form_name = null, $m_id = 'abc')
{
    try {

        $drawBox = '
        <div class="modal fade" id="' . $modal_id . '" tabindex="-1">
       <div class="modal-dialog modal-lg" role="document" id="' . $m_id . '">
           <div class="modal-content">
               <div class="modal-header">
                   <h5 class="modal-title">' . $boxTitle . '</h5>
                   <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                   </button>
               </div>
               <div class="modal-body p-b-0">
                   <form id="' . $form_name . '">
                       <div  id="' . $boxid . '">

                           </div>

               </div>
               <div class="modal-footer"> <span id="' . $status_msg . '" class="float-left"></span>
                   <button type="submit" class="btn btn-primary">'.trans('admin.save').' <i id="spiner-'.$form_name.'"></i></button>
                   <button type="button" class="btn btn-default" data-dismiss="modal">'.trans('admin.cancel').'</button>
               </div>
           </div>
           </form>
       </div>
   </div>';
        return $drawBox;
    } catch (Exception $exc) {
        // $this->tempVar = $exc->getMessage();
        return false;
    }
}

function modelDetail(string $modal_id = null, string $boxTitle = null, $boxid, string $status_msg = null, string $form_name = null, $m_id = 'abc', string $modal_size=null)
{
    try {

        $drawBox = '
        <div class="modal fade" id="' . $modal_id . '" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
           <div class="modal-dialog '.$modal_size.'" role="document" id="' . $m_id . '">
               <div class="modal-content">
                   <div class="modal-header">
                       <h5 class="modal-title">' . $boxTitle . '</h5>
                        <button type="button" onclick="window.location.reload();" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                   </div>
                   <div class="modal-body">
                       <form id="' . $form_name . '">
                        <div  id="' . $boxid . '">

                        </div>
                   </div>
                   <div class="modal-footer position-sticky bottom-0 bg-light">
                      <span id="' . $status_msg . '" class="float-left"></span>
                   </div>
               </div>
               </form>
           </div>
        </div>';
        return $drawBox;
    } catch (Exception $exc) {
        // $this->tempVar = $exc->getMessage();
        return false;
    }
}



//get coupon from id(zshan)
function getAny($colmn,$table,$id,$value){
  if(isset(DB::table($table)->where($id, $value)->first()->$colmn)){
    return DB::table($table)->where($id, $value)->first()->$colmn;
  }else{
    return "";
  }
}

// get all country
function getCountryList()
{
  return DB::table('countries')->where('c_status', 1)->get();
}
//get country by id
function getCountryName($c_id){
  if(Session::get('locale')=='en'){
    if(isset(DB::table('countries')->where('id', $c_id)->first()->value_en)){
      return DB::table('countries')->where('id', $c_id)->first()->value_en;
    }
    else{return "";}
  }else{
    if(isset(DB::table('countries')->where('id', $c_id)->first()->value_ar)){
      return DB::table('countries')->where('id', $c_id)->first()->value_ar;
    }
    else{return "";}
  }
}

// get all cities
function getCityList()
{
    return DB::table('cities')->where('city_status', 1)->orderBy('city_name', 'asc')->get();
}
//get city by id
function getCityName($city_id){
  if(Session::get('locale')=='en'){
    if(isset(DB::table('cities')->where('city_id', $city_id)->first()->city_name)){
      return DB::table('cities')->where('city_id', $city_id)->first()->city_name;
    }
    else{return "";}
  }else{
    if(isset(DB::table('cities')->where('city_id', $city_id)->first()->city_name_ar)){
      return DB::table('cities')->where('city_id', $city_id)->first()->city_name_ar;
    }
    else{return "";}
  }
}

function roleList()
{
    return DB::table('roles')->where('status', 1)->get();
}


function checkAccess($colmn){
  $role_id = Auth::user()->role;
  if ($role_id == 0) {
    return false;
  } else{
    $permission = DB::table('role_permissions')->where('role_id', $role_id)->first()->$colmn;
    if($permission == 1){ return true; } else{ return false; }
  }
}

function lang(){
  if (!empty(Session::get('locale'))) {
    return Session::get('locale');
  }
}
function colorList()
{
    return DB::table('colors')->where('status', 1)->get();
}

function pkgName($id){
  if(isset(DB::table('package')->where('id', $id)->first()->name_en)){
    return DB::table('package')->where('id', $id)->first()->name_en;
  } else{
    return "";
  }
}

function vendorInfo($id, $column="name"){
  if(isset(DB::table('vendor_detail')->where('uid', $id)->first()->$column)){
   $data = DB::table('vendor_detail')->where('uid', $id)->first()->$column;
   return $data;
  }else{
      return "";
  }
}
function customerInfo($id, $column="name"){
  if(isset(DB::table('user_detail')->where('uid', $id)->first()->$column)){
   $data = DB::table('user_detail')->where('uid', $id)->first()->$column;
   return $data;
  }else{
      return "";
  }
}