<?php
    use Illuminate\Support\Facades\Auth;
    use App\Models\Admin\User;

    function getLocales(){
        include_once('admin/locales.php');

        return $locales;
    }

    function getLanguages(){
        include_once('admin/languages.php');
        return $languages;
    }

    // function emoji($data, $device){
    //     include_once('admin/emoji.php');

    //     // $data = emoji_unified_to_docomo($data);   # DoCoMo devices
    //     // $data = emoji_unified_to_kddi($data);     # KDDI & Au devices

    //     if ($device == 'ios') {
    //         $data = emoji_unified_to_softbank($data); # Softbank & pre-iOS6 Apple devices

    //     }elseif ($device == 'android') {
    //         $data = emoji_unified_to_google($data);   # Google Android devices

    //     }

    //     return $data;
    // }

    function getToken($id, $device)
    {
        if ($device == 'ios') {
            return User::where('id', $id)->value('ios_device_id');

        }elseif ($device == 'android') {
            return User::where('id', $id)->value('android_device_id');

        }

    }

    function sendNotification($device_id, $title, $body, $serverkey, $type = "Admin")
    {
        // echo $device_id."<br>";
        // echo $title."<br>";
        // echo $body."<br>";
        // echo $serverkey."<br>";
        // exit();
        $body;
        $title;
        //#prep the bundle

        $notification = array(
            'body'  => $body,
            'title' => $title,
            'type' => $type,
            'id' => 1,
            'icon'  => 'myicon', /*Default Icon*/
            'sound' => 'bingbong.aiff' /*Default sound*/
        );
        $fields = array
        (
            'to'        => $device_id,
            'notification'  => $notification
        );
        $headers = array
        (
            'Authorization: key='.$serverkey,
            'Content-Type: application/json'
        );
        #Send Reponse To FireBase Server
        $ch = curl_init();
        curl_setopt( $ch,CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send' );
        curl_setopt( $ch,CURLOPT_POST, true );
        curl_setopt( $ch,CURLOPT_HTTPHEADER, $headers );
        curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
        curl_setopt( $ch,CURLOPT_SSL_VERIFYPEER, false );
        curl_setopt( $ch,CURLOPT_POSTFIELDS, json_encode( $fields ) );
        $result = curl_exec($ch );
        curl_close( $ch );
        #Echo Result Of FireBase Server
        // print_r($result);


    }


//firebase notifications
function sendNotification_andriod($device_id, $title, $body, $serverkey, $type = "Admin", $apptype = "",$ref_id= ""){

    //API URL of FCM
    $url = 'https://fcm.googleapis.com/fcm/send';

    $api_key = $serverkey;

    $fields = array (
        'registration_ids' => array (
                $device_id
        ),
        'data' => array (
		"title" => $title,
        "message" => $body,
		"type"=> $type,
        "apptype"=> $apptype,
        "ref_id"=> $ref_id,
        )
    );

    //header includes Content type and api key
    $headers = array(
        'Content-Type:application/json',
        'Authorization:key='.$api_key
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    $result = curl_exec($ch);
    if ($result === FALSE) {
        die('FCM Send Error: ' . curl_error($ch));
    }
    curl_close($ch);
    return $result;
}



    /*email*/
    function email_host_list(){
        $data = DB::table('email_hosts')->whereStatus('1')->get();
        return $data;
    }
    function templates_list(){
        $data = DB::table('email_templates')->where('status',1)->get();
        return $data;
    }

    /*sms*/
    function sms_host_list(){
        $data = DB::table('sms_hosts')->whereStatus('1')->get();
        return $data;
    }
    function sms_templates_list(){
        $data = DB::table('sms_templates')->where('status','1')->get();
        return $data;
    }

    /*notifications*/
    function notification_host_list(){
        $data = DB::table('notification_hosts')->whereStatus('1')->get();
        return $data;
    }
    function notification_templates_list(){
        $data = DB::table('notification_templates')->where('status','1')->get();
        return $data;
    }

    function userInfo($id, $column="name"){
        $data = DB::table('users')->where('id', $id)->first()->$column;
        return $data;
    }

	/* get user type */
	function getUserType($type_id){
  if(Session::get('locale')=='en'){
    if(isset(DB::table('users_type')->where('id', $type_id)->first()->label_en)){
      return DB::table('users_type')->where('id', $type_id)->first()->label_en;
    }
    else{return "";}
  }else{
    if(isset(DB::table('users_type')->where('id', $type_id)->first()->label_ar)){
      return DB::table('users_type')->where('id', $type_id)->first()->label_ar;
    }
    else{return "";}
  }
}

/* get user type list */

function getUserTypeList()
{
    $types =  DB::table('users_type')->where('status', '1')->orderBy('label_en', 'asc')->get();
	foreach ($types as $type){
		if(Session::get('locale')=='en'){
    echo '<option value="'.$type->id.'">'.$type->label_en.'</option>';
		}else{
		echo '<option value="'.$type->id.'">'.$type->label_ar.'</option>';
		}
	}
}
//get product by id
function getSiteInfo($value){
    if ($value) {
        return DB::table('site_info')->first()->$value;
    } else {
        echo "";
    }
}
