<?php

namespace App\Traits;




trait SendResponse
{
    public function sendGeneralResponse($success=true,$message_en ="",$message_ar="",$redirect = "" ,$body= [] ,$code=200)
    {
       
        if(count($body) > 0){
            $response = [
                'success' => $success,
                'message_en' => $message_en,
                'message_ar' => $message_ar,
                'redirect' => $redirect,
                'body' => $body,
            ];
        }else{
            $response = [
                'success' => $success,
                'message_en' => $message_en,
                'message_ar' => $message_ar,
            ];
        }

        return response()->json($response, $code);
    }
    public function sendResponse($result, $token, $message_en,$message_ar, $redirect = 'home')
    {
        $response = [
            'success' => true,
            'token' => $token,
            'token_type' => 'Bearer',
            'data'    => $result,
            'message_en' => $message_en,
            'message_ar' => $message_ar,
            'redirect' => $redirect,
        ];


        return response()->json($response, 200);
    }

    public function sendError($message_en,$message_ar, $errorMessages = [], $code = 404, $redirect = 'register')
    {
        $response = [
            'success' => false,
            'message_en' => $message_en,
            'message_ar' => $message_ar,
            'redirect' => $redirect,

        ];


        if (!empty($errorMessages)) {
            $response['data'] = $errorMessages;
        }


        return response()->json($response, $code);
    }


    public function sendOtp($otp, $message_en, $message_ar, $redirect = 'home')
    {
        $response = [
            'success' => true,
            'otp' => $otp,
            // 'mobile' =>
            'message_en' => $message_en,
            'message_ar' => $message_ar,
            'redirect' => $redirect,
        ];


        return response()->json($response, 200);
    }

    public function sendResponseForRegisteration($message_en,$message_ar)
    {
        $response = [
            'success' => true,
            'message_en' => $message_en,
            'message_ar' => $message_ar,
            'redirect' => "register",
        ];
        return response()->json($response, 200);

    }
}
